<?php $__env->startSection('title', 'Pedidos'); ?>

<?php $__env->startSection('header', 'Gerenciar Pedidos'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto">
    <!-- Stats -->
    <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4 mb-6">
        <div class="bg-white rounded-lg shadow-sm p-4">
            <p class="text-sm text-gray-600">Total</p>
            <p class="text-2xl font-bold text-gray-800"><?php echo e($stats['total']); ?></p>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-4 border-l-4 border-yellow-500">
            <p class="text-sm text-gray-600">Pendentes</p>
            <p class="text-2xl font-bold text-yellow-600"><?php echo e($stats['pending']); ?></p>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-4 border-l-4 border-green-500">
            <p class="text-sm text-gray-600">Confirmados</p>
            <p class="text-2xl font-bold text-green-600"><?php echo e($stats['confirmed']); ?></p>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-4 border-l-4 border-blue-500">
            <p class="text-sm text-gray-600">Processando</p>
            <p class="text-2xl font-bold text-blue-600"><?php echo e($stats['processing']); ?></p>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-4 border-l-4 border-purple-500">
            <p class="text-sm text-gray-600">Enviados</p>
            <p class="text-2xl font-bold text-purple-600"><?php echo e($stats['shipped']); ?></p>
        </div>
        <div class="bg-white rounded-lg shadow-sm p-4 border-l-4 border-gray-400">
            <p class="text-sm text-gray-600">Entregues</p>
            <p class="text-2xl font-bold text-gray-600"><?php echo e($stats['delivered']); ?></p>
        </div>
    </div>

    <!-- Filtros -->
    <div class="bg-white rounded-lg shadow-sm p-4 mb-6">
        <form method="GET" action="<?php echo e(route('admin.orders.index')); ?>" class="flex flex-wrap gap-4">
            <div class="flex-1 min-w-[200px]">
                <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Buscar por pedido, nome ou e-mail"
                       class="w-full px-4 py-2 border rounded-lg">
            </div>
            <div>
                <select name="status" class="px-4 py-2 border rounded-lg">
                    <option value="">Todos os Status</option>
                    <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pendente</option>
                    <option value="confirmed" <?php echo e(request('status') === 'confirmed' ? 'selected' : ''); ?>>Confirmado</option>
                    <option value="processing" <?php echo e(request('status') === 'processing' ? 'selected' : ''); ?>>Processando</option>
                    <option value="shipped" <?php echo e(request('status') === 'shipped' ? 'selected' : ''); ?>>Enviado</option>
                    <option value="delivered" <?php echo e(request('status') === 'delivered' ? 'selected' : ''); ?>>Entregue</option>
                    <option value="cancelled" <?php echo e(request('status') === 'cancelled' ? 'selected' : ''); ?>>Cancelado</option>
                </select>
            </div>
            <div>
                <select name="payment_status" class="px-4 py-2 border rounded-lg">
                    <option value="">Todos os Pagamentos</option>
                    <option value="pending" <?php echo e(request('payment_status') === 'pending' ? 'selected' : ''); ?>>Pendente</option>
                    <option value="paid" <?php echo e(request('payment_status') === 'paid' ? 'selected' : ''); ?>>Pago</option>
                    <option value="cancelled" <?php echo e(request('payment_status') === 'cancelled' ? 'selected' : ''); ?>>Cancelado</option>
                    <option value="refunded" <?php echo e(request('payment_status') === 'refunded' ? 'selected' : ''); ?>>Reembolsado</option>
                </select>
            </div>
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Filtrar
            </button>
            <?php if(request()->hasAny(['search', 'status', 'payment_status'])): ?>
                <a href="<?php echo e(route('admin.orders.index')); ?>" class="px-6 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300">
                    Limpar
                </a>
            <?php endif; ?>
        </form>
    </div>

    <!-- Tabela de Pedidos -->
    <div class="bg-white rounded-lg shadow-sm overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 border-b">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Pedido</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Cliente</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Valor</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Pagamento</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Data</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ações</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-blue-600"><?php echo e($order->order_number); ?></div>
                                <div class="text-xs text-gray-500"><?php echo e($order->items->count()); ?> item(s)</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-900"><?php echo e($order->customer_name); ?></div>
                                <div class="text-sm text-gray-500"><?php echo e($order->customer_email); ?></div>
                                <div class="text-xs text-gray-400"><?php echo e($order->customer_phone); ?></div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-bold text-gray-900">R$ <?php echo e(number_format($order->total, 2, ',', '.')); ?></div>
                                <?php if($order->installments): ?>
                                    <div class="text-xs text-gray-500"><?php echo e($order->installments); ?>x</div>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex flex-col gap-1">
                                    <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium
                                        <?php echo e($order->payment_method === 'pix' ? 'bg-teal-100 text-teal-800' :
                                           ($order->payment_method === 'credit_card' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800')); ?>">
                                        <?php echo e($order->payment_method_label); ?>

                                    </span>
                                    <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium
                                        <?php echo e($order->payment_status === 'paid' ? 'bg-green-100 text-green-800' :
                                           ($order->payment_status === 'pending' ? 'bg-yellow-100 text-yellow-800' :
                                           ($order->payment_status === 'cancelled' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-800'))); ?>">
                                        <?php echo e($order->payment_status_label); ?>

                                    </span>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium
                                    <?php echo e($order->status === 'pending' ? 'bg-yellow-100 text-yellow-800' :
                                       ($order->status === 'confirmed' ? 'bg-green-100 text-green-800' :
                                       ($order->status === 'processing' ? 'bg-blue-100 text-blue-800' :
                                       ($order->status === 'shipped' ? 'bg-purple-100 text-purple-800' :
                                       ($order->status === 'delivered' ? 'bg-gray-100 text-gray-800' : 'bg-red-100 text-red-800'))))); ?>">
                                    <?php echo e($order->status_label); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                <?php echo e($order->created_at->format('d/m/Y')); ?>

                                <br>
                                <span class="text-xs"><?php echo e($order->created_at->format('H:i')); ?></span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <a href="<?php echo e(route('admin.orders.show', $order)); ?>" class="text-blue-600 hover:text-blue-800">
                                    Ver Detalhes
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="px-6 py-12 text-center text-gray-500">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 mx-auto text-gray-300 mb-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                </svg>
                                <p>Nenhum pedido encontrado</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Paginação -->
        <?php if($orders->hasPages()): ?>
            <div class="bg-gray-50 px-6 py-4 border-t">
                <?php echo e($orders->appends(request()->query())->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\fabio\OneDrive\Documentos\katia\suplementos\resources\views/admin/orders/index.blade.php ENDPATH**/ ?>