<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Painel Admin'); ?> - Bella Nutri</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                        serif: ['Playfair Display', 'serif'],
                    },
                    colors: {
                        pink: {
                            50: '#fdf2f8',
                            100: '#fce7f3',
                            200: '#fbcfe8',
                            300: '#f9a8d4',
                            400: '#f472b6',
                            500: '#ec4899',
                            600: '#db2777',
                            700: '#be185d',
                            800: '#9d174d',
                            900: '#831843',
                        },
                        rose: {
                            50: '#fff1f2',
                            100: '#ffe4e6',
                            200: '#fecdd3',
                            300: '#fda4af',
                            400: '#fb7185',
                            500: '#f43f5e',
                            600: '#e11d48',
                            700: '#be123c',
                            800: '#9f1239',
                            900: '#881337',
                        }
                    }
                }
            }
        }
    </script>

    <style>
        [x-cloak] { display: none !important; }

        .gradient-text {
            background: linear-gradient(135deg, #ec4899 0%, #f43f5e 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .sidebar-gradient {
            background: linear-gradient(180deg, #1f2937 0%, #111827 100%);
        }

        .nav-item {
            transition: all 0.3s ease;
        }

        .nav-item:hover {
            transform: translateX(4px);
        }

        .nav-item.active {
            background: linear-gradient(90deg, rgba(236, 72, 153, 0.2) 0%, transparent 100%);
            border-left: 3px solid #ec4899;
        }

        .card-hover {
            transition: all 0.3s ease;
        }

        .card-hover:hover {
            transform: translateY(-4px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        }

        .stat-card {
            background: linear-gradient(135deg, #ffffff 0%, #fdf2f8 100%);
        }

        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        ::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, #ec4899 0%, #f43f5e 100%);
            border-radius: 10px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(135deg, #db2777 0%, #e11d48 100%);
        }
    </style>
</head>
<body class="bg-gray-50 font-sans">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <aside class="w-64 sidebar-gradient text-white flex flex-col shadow-2xl">
            <!-- Logo -->
            <div class="p-6 border-b border-gray-700/50">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-gradient-to-br from-pink-500 to-rose-500 rounded-xl flex items-center justify-center shadow-lg">
                        <i class="fas fa-spa text-white text-lg"></i>
                    </div>
                    <div>
                        <h1 class="text-lg font-bold font-serif">Bella Nutri</h1>
                        <p class="text-xs text-gray-400">Painel Administrativo</p>
                    </div>
                </div>
            </div>

            <!-- Navigation -->
            <nav class="flex-1 overflow-y-auto py-6 px-3">
                <ul class="space-y-1">
                    <!-- Dashboard -->
                    <li>
                        <a href="<?php echo e(route('admin.dashboard')); ?>"
                           class="nav-item flex items-center px-4 py-3 rounded-xl <?php echo e(request()->routeIs('admin.dashboard') ? 'active text-pink-400' : 'text-gray-300 hover:bg-gray-800 hover:text-white'); ?>">
                            <i class="fas fa-home w-5 mr-3 text-center"></i>
                            <span class="font-medium">Dashboard</span>
                        </a>
                    </li>

                    <!-- Produtos -->
                    <li>
                        <a href="<?php echo e(route('admin.products.index')); ?>"
                           class="nav-item flex items-center px-4 py-3 rounded-xl <?php echo e(request()->routeIs('admin.products.*') ? 'active text-pink-400' : 'text-gray-300 hover:bg-gray-800 hover:text-white'); ?>">
                            <i class="fas fa-box w-5 mr-3 text-center"></i>
                            <span class="font-medium">Produtos</span>
                        </a>
                    </li>

                    <!-- Combos -->
                    <li>
                        <a href="<?php echo e(route('admin.combos.index')); ?>"
                           class="nav-item flex items-center px-4 py-3 rounded-xl <?php echo e(request()->routeIs('admin.combos.*') ? 'active text-pink-400' : 'text-gray-300 hover:bg-gray-800 hover:text-white'); ?>">
                            <i class="fas fa-gift w-5 mr-3 text-center"></i>
                            <span class="font-medium">Combos/Kits</span>
                        </a>
                    </li>

                    <!-- Pedidos -->
                    <li>
                        <a href="<?php echo e(route('admin.orders.index')); ?>"
                           class="nav-item flex items-center px-4 py-3 rounded-xl <?php echo e(request()->routeIs('admin.orders.*') ? 'active text-pink-400' : 'text-gray-300 hover:bg-gray-800 hover:text-white'); ?>">
                            <i class="fas fa-shopping-cart w-5 mr-3 text-center"></i>
                            <span class="font-medium">Pedidos</span>
                        </a>
                    </li>

                    <!-- Cupons -->
                    <li>
                        <a href="<?php echo e(route('admin.coupons.index')); ?>"
                           class="nav-item flex items-center px-4 py-3 rounded-xl <?php echo e(request()->routeIs('admin.coupons.*') ? 'active text-pink-400' : 'text-gray-300 hover:bg-gray-800 hover:text-white'); ?>">
                            <i class="fas fa-ticket-alt w-5 mr-3 text-center"></i>
                            <span class="font-medium">Cupons</span>
                        </a>
                    </li>

                    <!-- Variantes -->
                    <li>
                        <a href="<?php echo e(route('admin.variants.index')); ?>"
                           class="nav-item flex items-center px-4 py-3 rounded-xl <?php echo e(request()->routeIs('admin.variants.*') ? 'active text-pink-400' : 'text-gray-300 hover:bg-gray-800 hover:text-white'); ?>">
                            <i class="fas fa-palette w-5 mr-3 text-center"></i>
                            <span class="font-medium">Variantes</span>
                        </a>
                    </li>

                    <!-- Configurações -->
                    <li>
                        <a href="<?php echo e(route('admin.settings.index')); ?>"
                           class="nav-item flex items-center px-4 py-3 rounded-xl <?php echo e(request()->routeIs('admin.settings.*') ? 'active text-pink-400' : 'text-gray-300 hover:bg-gray-800 hover:text-white'); ?>">
                            <i class="fas fa-cog w-5 mr-3 text-center"></i>
                            <span class="font-medium">Configurações</span>
                        </a>
                    </li>
                </ul>
            </nav>

            <!-- User Info & Logout -->
            <div class="p-4 border-t border-gray-700/50">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-gradient-to-br from-pink-500 to-rose-500 rounded-full flex items-center justify-center font-bold">
                            <?php echo e(substr(auth()->user()->name, 0, 1)); ?>

                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium truncate"><?php echo e(auth()->user()->name); ?></p>
                            <p class="text-xs text-gray-400">Administrador</p>
                        </div>
                    </div>
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="p-2 text-gray-400 hover:text-pink-400 transition" title="Sair">
                            <i class="fas fa-sign-out-alt"></i>
                        </button>
                    </form>
                </div>
            </div>
        </aside>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Top Header -->
            <header class="bg-white shadow-sm border-b border-gray-100">
                <div class="px-6 py-4 flex items-center justify-between">
                    <div class="flex items-center space-x-4">
                        <h1 class="text-2xl font-bold text-gray-800">
                            <?php echo $__env->yieldContent('header', 'Dashboard'); ?>
                        </h1>
                    </div>

                    <div class="flex items-center space-x-4">
                        <!-- View Site -->
                        <a href="<?php echo e(route('home')); ?>" target="_blank"
                           class="px-4 py-2 bg-gradient-to-r from-pink-500 to-rose-500 text-white rounded-xl hover:from-pink-600 hover:to-rose-600 transition text-sm font-medium flex items-center">
                            <i class="fas fa-external-link-alt mr-2"></i>
                            Ver Site
                        </a>

                        <!-- Notifications -->
                        <button class="relative p-2 text-gray-500 hover:text-pink-500 transition">
                            <i class="fas fa-bell text-xl"></i>
                            <span class="absolute top-0 right-0 w-2 h-2 bg-pink-500 rounded-full"></span>
                        </button>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 overflow-y-auto p-6">
                <!-- Flash Messages -->
                <?php if(session('success')): ?>
                    <div class="mb-6 p-4 bg-green-50 border-l-4 border-green-500 rounded-xl flex items-center animate-bounce">
                        <i class="fas fa-check-circle text-green-500 mr-3 text-xl"></i>
                        <p class="text-green-700 font-medium"><?php echo e(session('success')); ?></p>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="mb-6 p-4 bg-red-50 border-l-4 border-red-500 rounded-xl flex items-center animate-bounce">
                        <i class="fas fa-exclamation-circle text-red-500 mr-3 text-xl"></i>
                        <p class="text-red-700 font-medium"><?php echo e(session('error')); ?></p>
                    </div>
                <?php endif; ?>

                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </div>

    <?php echo $__env->yieldPushContent('scripts'); ?>

    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
</body>
</html>
<?php /**PATH C:\Users\fabio\OneDrive\Documentos\katia\suplementos\resources\views/admin/layouts/app.blade.php ENDPATH**/ ?>