<?php $__env->startSection('title', 'Bella Nutri - Suplementos Premium para Mulheres'); ?>

<?php $__env->startSection('description', 'Descubra suplementos premium desenvolvidos especialmente para mulheres que buscam equilíbrio, bem-estar e autoestima.'); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Section -->
<section class="relative min-h-screen flex items-center hero-gradient overflow-hidden">
    <!-- Decorative Blobs -->
    <div class="absolute top-20 right-0 w-96 h-96 bg-gradient-to-br from-pink-300/30 to-rose-300/30 rounded-full blur-3xl animate-pulse-slow"></div>
    <div class="absolute bottom-20 left-0 w-80 h-80 bg-gradient-to-br from-purple-300/30 to-pink-300/30 rounded-full blur-3xl animate-pulse-slow" style="animation-delay: 2s;"></div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20 relative z-10">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Left Content -->
            <div class="space-y-8">
                <div class="inline-flex items-center space-x-2 bg-white px-5 py-2.5 rounded-full shadow-lg">
                    <span class="w-2 h-2 bg-pink-500 rounded-full animate-pulse"></span>
                    <span class="text-sm font-semibold text-gray-700">Feito especialmente para você</span>
                </div>

                <h1 class="text-5xl md:text-6xl lg:text-7xl font-serif font-bold leading-tight text-gray-900">
                    Sua beleza e
                    <span class="gradient-text">saúde</span>
                    em primeiro lugar
                </h1>

                <p class="text-xl text-gray-600 leading-relaxed max-w-xl">
                    Descubra suplementos premium formulados com ingredientes naturais para potencializar sua jornada de bem-estar.
                </p>

                <div class="flex flex-col sm:flex-row gap-4">
                    <a href="<?php echo e(route('products.index')); ?>" class="btn-gradient px-10 py-4 text-white font-semibold rounded-full shadow-xl inline-flex items-center justify-center">
                        <i class="fas fa-sparkles mr-2"></i>
                        Explorar Produtos
                    </a>
                    <a href="#featured" class="px-10 py-4 bg-white text-gray-700 font-semibold rounded-full border-2 border-pink-200 hover:border-pink-300 transition inline-flex items-center justify-center">
                        <i class="fas fa-star text-amber-400 mr-2"></i>
                        Ver Destaques
                    </a>
                </div>

                <!-- Trust Indicators -->
                <div class="flex items-center space-x-8 pt-6">
                    <div class="text-center">
                        <div class="text-3xl font-bold gradient-text">10k+</div>
                        <div class="text-sm text-gray-500">Clientes Felizes</div>
                    </div>
                    <div class="w-px h-12 bg-gray-200"></div>
                    <div class="text-center">
                        <div class="text-3xl font-bold gradient-text">100%</div>
                        <div class="text-sm text-gray-500">Natural</div>
                    </div>
                    <div class="w-px h-12 bg-gray-200"></div>
                    <div class="text-center">
                        <div class="text-3xl font-bold gradient-text">4.9</div>
                        <div class="text-sm text-gray-500">Avaliação</div>
                    </div>
                </div>
            </div>

            <!-- Right Content - Hero Image -->
            <div class="relative hidden lg:block">
                <div class="relative animate-float">
                    <div class="absolute inset-0 bg-gradient-to-br from-pink-400/20 to-rose-400/20 rounded-[3rem] transform rotate-6"></div>
                    <div class="relative bg-white rounded-[2.5rem] p-8 shadow-2xl">
                        <div class="aspect-[4/5] bg-gradient-to-br from-pink-100 to-rose-100 rounded-[2rem] flex items-center justify-center">
                            <div class="text-center space-y-4">
                                <div class="w-32 h-32 bg-gradient-to-br from-pink-400 to-rose-500 rounded-full flex items-center justify-center mx-auto shadow-xl">
                                    <i class="fas fa-spa text-white text-5xl"></i>
                                </div>
                                <p class="text-gray-700 font-serif text-xl">Bela por fora,<br>maravilhosa por dentro</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Floating Elements -->
                <div class="absolute -top-4 -right-4 bg-white p-4 rounded-2xl shadow-xl animate-bounce">
                    <div class="flex items-center space-x-2">
                        <i class="fas fa-leaf text-green-500"></i>
                        <span class="font-semibold text-gray-700">100% Natural</span>
                    </div>
                </div>

                <div class="absolute bottom-10 -left-8 bg-white p-4 rounded-2xl shadow-xl animate-bounce" style="animation-delay: 1s;">
                    <div class="flex items-center space-x-2">
                        <i class="fas fa-heart text-pink-500"></i>
                        <span class="font-semibold text-gray-700">Testado Clinicalmente</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Wave Divider -->
    <div class="absolute bottom-0 left-0 w-full overflow-hidden leading-none">
        <svg class="relative block w-full h-16" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none">
            <path d="M321.39,56.44c58-10.79,114.16-30.13,172-41.86,82.39-16.72,168.19-17.73,250.45-.39C823.78,31,906.67,72,985.66,92.83c70.05,18.48,146.53,26.09,214.34,3V0H0V27.35A600.21,600.21,0,0,0,321.39,56.44Z" class="fill-white"></path>
        </svg>
    </div>
</section>

<!-- Benefits Section -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <!-- Benefit 1 -->
            <div class="text-center p-6 rounded-3xl bg-gradient-to-br from-pink-50 to-rose-50 card-hover">
                <div class="w-16 h-16 bg-gradient-to-br from-pink-400 to-rose-500 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                    <i class="fas fa-truck text-white text-2xl"></i>
                </div>
                <h3 class="font-semibold text-gray-800 mb-2">Frete Grátis</h3>
                <p class="text-gray-500 text-sm">Em compras acima de R$ 150</p>
            </div>

            <!-- Benefit 2 -->
            <div class="text-center p-6 rounded-3xl bg-gradient-to-br from-purple-50 to-pink-50 card-hover">
                <div class="w-16 h-16 bg-gradient-to-br from-purple-400 to-pink-500 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                    <i class="fas fa-heart text-white text-2xl"></i>
                </div>
                <h3 class="font-semibold text-gray-800 mb-2">Fórmula Única</h3>
                <p class="text-gray-500 text-sm">Desenvolvida para mulheres</p>
            </div>

            <!-- Benefit 3 -->
            <div class="text-center p-6 rounded-3xl bg-gradient-to-br from-rose-50 to-pink-50 card-hover">
                <div class="w-16 h-16 bg-gradient-to-br from-rose-400 to-pink-500 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                    <i class="fas fa-leaf text-white text-2xl"></i>
                </div>
                <h3 class="font-semibold text-gray-800 mb-2">100% Natural</h3>
                <p class="text-gray-500 text-sm">Ingredientes selecionados</p>
            </div>

            <!-- Benefit 4 -->
            <div class="text-center p-6 rounded-3xl bg-gradient-to-br from-pink-50 to-purple-50 card-hover">
                <div class="w-16 h-16 bg-gradient-to-br from-pink-400 to-purple-500 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                    <i class="fas fa-headset text-white text-2xl"></i>
                </div>
                <h3 class="font-semibold text-gray-800 mb-2">Suporte Love</h3>
                <p class="text-gray-500 text-sm">Atendimento especializado</p>
            </div>
        </div>
    </div>
</section>

<!-- Featured Products -->
<section id="featured" class="py-24 bg-gradient-to-br from-pink-50 via-white to-rose-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Section Header -->
        <div class="text-center mb-16">
            <div class="inline-flex items-center space-x-2 bg-pink-100 px-5 py-2 rounded-full mb-6">
                <i class="fas fa-star text-amber-400"></i>
                <span class="text-sm font-semibold text-pink-700">Selecionadas para Você</span>
            </div>
            <h2 class="text-4xl md:text-5xl font-serif font-bold text-gray-900 mb-4">
                Produtos em
                <span class="gradient-text">Destaque</span>
            </h2>
            <p class="text-xl text-gray-600 max-w-2xl mx-auto">
                Nossa seleção especial com os suplementos mais amados pelas nossas clientes.
            </p>
        </div>

        <?php if(isset($featuredProducts) && $featuredProducts->count() > 0): ?>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
                <?php $__currentLoopData = $featuredProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($product): ?>
                        <?php echo $__env->make('partials.product-card', ['product' => $product], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="text-center py-16">
                <div class="w-24 h-24 bg-pink-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-spa text-pink-400 text-4xl"></i>
                </div>
                <p class="text-gray-500 text-lg">Em breve teremos produtos disponíveis.</p>
            </div>
        <?php endif; ?>

        <div class="text-center mt-12">
            <a href="<?php echo e(route('products.index')); ?>" class="btn-gradient px-10 py-4 text-white font-semibold rounded-full shadow-xl inline-flex items-center">
                Ver Todos os Produtos
                <i class="fas fa-arrow-right ml-2"></i>
            </a>
        </div>
    </div>
</section>

<!-- Categories Section -->
<?php if(isset($categories) && $categories->count() > 0): ?>
<section class="py-24 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Section Header -->
        <div class="text-center mb-16">
            <div class="inline-flex items-center space-x-2 bg-purple-100 px-5 py-2 rounded-full mb-6">
                <i class="fas fa-leaf text-purple-500"></i>
                <span class="text-sm font-semibold text-purple-700">Explore por Categoria</span>
            </div>
            <h2 class="text-4xl md:text-5xl font-serif font-bold text-gray-900 mb-4">
                Nossas
                <span class="gradient-text">Categorias</span>
            </h2>
            <p class="text-xl text-gray-600">
                Encontre o suplemento perfeito para cada momento da sua jornada.
            </p>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-6">
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($category && $category->name): ?>
                    <a href="<?php echo e(route('categories.show', $category->slug)); ?>"
                       class="group bg-gradient-to-br from-pink-50 to-purple-50 hover:from-pink-100 hover:to-purple-100 rounded-3xl p-6 text-center transition-all duration-300 card-hover">
                        <div class="w-16 h-16 bg-white rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-sm group-hover:scale-110 transition-transform">
                            <i class="fas fa-leaf text-2xl text-pink-500"></i>
                        </div>
                        <h3 class="font-semibold text-gray-800 group-hover:text-pink-600 transition"><?php echo e($category->name); ?></h3>
                        <p class="text-sm text-gray-500 mt-2"><?php echo e($category->products_count ?? 0); ?> produtos</p>
                    </a>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Special Offer Banner -->
<?php if(isset($discountProducts) && $discountProducts->count() > 0): ?>
<section class="py-24 bg-gradient-to-br from-rose-400 via-pink-500 to-purple-500 text-white relative overflow-hidden">
    <!-- Background Decorations -->
    <div class="absolute top-0 right-0 w-96 h-96 bg-white/10 rounded-full -translate-y-1/2 translate-x-1/2"></div>
    <div class="absolute bottom-0 left-0 w-64 h-64 bg-white/10 rounded-full translate-y-1/2 -translate-x-1/2"></div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="flex flex-col lg:flex-row items-center justify-between gap-12">
            <!-- Left Content -->
            <div class="text-center lg:text-left">
                <div class="inline-flex items-center space-x-2 bg-white/20 px-5 py-2 rounded-full mb-6">
                    <i class="fas fa-fire"></i>
                    <span class="font-semibold">Ofertas por Tempo Limitado</span>
                </div>
                <h2 class="text-4xl md:text-5xl font-serif font-bold mb-6">
                    Até 50% de
                    <span class="text-amber-300">Desconto</span>
                </h2>
                <p class="text-pink-100 text-lg mb-8">
                    Aproveite nossas ofertas exclusivas antes que acabem!
                </p>
                <a href="<?php echo e(route('products.index', ['with_discount' => 1])); ?>"
                   class="inline-flex items-center px-10 py-4 bg-white text-pink-600 font-bold rounded-full hover:bg-pink-50 transition transform hover:scale-105 shadow-xl">
                    Ver Ofertas
                    <i class="fas fa-sparkles ml-2"></i>
                </a>
            </div>

            <!-- Right Content - Products -->
            <div class="flex flex-wrap justify-center gap-5">
                <?php $__currentLoopData = $discountProducts->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($product): ?>
                        <a href="<?php echo e(route('products.show', $product->slug)); ?>"
                           class="bg-white/10 backdrop-blur-sm border border-white/20 rounded-3xl p-5 w-52 hover:bg-white/20 transition-all duration-300">
                            <?php if($product->images && $product->images->first()): ?>
                                <img src="<?php echo e($product->images->first()->url); ?>" alt="<?php echo e($product->name); ?>"
                                     class="w-full h-36 object-cover rounded-2xl mb-4">
                            <?php else: ?>
                                <div class="w-full h-36 bg-white/10 rounded-2xl mb-4 flex items-center justify-center">
                                    <i class="fas fa-spa text-white/50 text-4xl"></i>
                                </div>
                            <?php endif; ?>
                            <h4 class="font-semibold text-sm line-clamp-2 mb-3"><?php echo e($product->name); ?></h4>
                            <?php if($product->discount_price): ?>
                                <span class="text-xs text-pink-200 line-through">R$ <?php echo e(number_format($product->price, 2, ',', '.')); ?></span>
                            <?php endif; ?>
                            <span class="text-xl font-bold">R$ <?php echo e(number_format($product->final_price ?? $product->price, 2, ',', '.')); ?></span>
                        </a>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Testimonials Section -->
<?php if(isset($testimonials) && $testimonials->count() > 0): ?>
<section class="py-24 bg-gradient-to-br from-pink-50 via-white to-purple-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Section Header -->
        <div class="text-center mb-16">
            <div class="inline-flex items-center space-x-2 bg-rose-100 px-5 py-2 rounded-full mb-6">
                <i class="fas fa-heart text-rose-500"></i>
                <span class="text-sm font-semibold text-rose-700">Amor & Confiança</span>
            </div>
            <h2 class="text-4xl md:text-5xl font-serif font-bold text-gray-900 mb-4">
                O que dizem
                <span class="gradient-text">sobre nós</span>
            </h2>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($testimonial): ?>
                    <div class="bg-white rounded-3xl p-8 shadow-lg card-hover">
                        <div class="flex items-center mb-6">
                            <?php for($i = 1; $i <= 5; $i++): ?>
                                <i class="fas fa-star <?php echo e($i <= ($testimonial->rating ?? 5) ? 'text-amber-400' : 'text-gray-200'); ?>"></i>
                            <?php endfor; ?>
                        </div>
                        <p class="text-gray-600 mb-6 italic leading-relaxed">"<?php echo e($testimonial->comment ?? ''); ?>"</p>
                        <div class="flex items-center">
                            <?php if($testimonial->photo_url): ?>
                                <img src="<?php echo e($testimonial->photo_url); ?>" alt="<?php echo e($testimonial->name); ?>"
                                     class="w-12 h-12 rounded-full object-cover mr-4 border-2 border-pink-200">
                            <?php else: ?>
                                <div class="w-12 h-12 bg-gradient-to-br from-pink-400 to-rose-400 rounded-full flex items-center justify-center mr-4">
                                    <i class="fas fa-user text-white"></i>
                                </div>
                            <?php endif; ?>
                            <div>
                                <span class="font-semibold text-gray-800"><?php echo e($testimonial->name ?? ''); ?></span>
                                <p class="text-xs text-pink-500">Cliente verificada</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- CTA Section -->
<section class="py-24 bg-white">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <div class="bg-gradient-to-br from-pink-50 to-rose-50 rounded-[3rem] p-12 md:p-16 relative overflow-hidden">
            <!-- Decorative Elements -->
            <div class="absolute top-0 right-0 w-40 h-40 bg-pink-200/30 rounded-full blur-3xl"></div>
            <div class="absolute bottom-0 left-0 w-40 h-40 bg-rose-200/30 rounded-full blur-3xl"></div>

            <div class="relative z-10">
                <div class="w-20 h-20 bg-gradient-to-br from-pink-400 to-rose-500 rounded-full flex items-center justify-center mx-auto mb-6 shadow-xl">
                    <i class="fas fa-heart text-white text-3xl"></i>
                </div>
                <h2 class="text-3xl md:text-4xl font-serif font-bold text-gray-900 mb-4">
                    Pronta para transformar sua vida?
                </h2>
                <p class="text-xl text-gray-600 mb-8 max-w-2xl mx-auto">
                    Junte-se a milhares de mulheres que já descobriram o poder dos suplementos Bella Nutri.
                </p>
                <a href="<?php echo e(route('products.index')); ?>" class="btn-gradient px-12 py-5 text-white font-bold rounded-full shadow-xl inline-flex items-center text-lg">
                    Começar Agora
                    <i class="fas fa-arrow-right ml-2"></i>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Newsletter Section -->
<?php $__env->startSection('newsletter'); ?>
<section class="py-16 bg-gradient-to-r from-pink-500 to-rose-500">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl md:text-4xl font-serif font-bold text-white mb-4">
            Receba Ofertas Exclusivas
        </h2>
        <p class="text-pink-100 text-lg mb-8">
            Inscreva-se e receba 15% de desconto na sua primeira compra!
        </p>
        <form class="flex flex-col sm:flex-row gap-4 max-w-xl mx-auto">
            <input type="email" placeholder="Seu melhor e-mail"
                   class="flex-1 px-6 py-4 rounded-full focus:outline-none focus:ring-4 focus:ring-pink-300">
            <button type="submit" class="px-8 py-4 bg-gray-900 text-white font-semibold rounded-full hover:bg-gray-800 transition">
                Quero Desconto
            </button>
        </form>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\fabio\OneDrive\Documentos\katia\suplementos\resources\views/home.blade.php ENDPATH**/ ?>