<nav class="fixed w-full z-50 bg-white/90 backdrop-blur-md shadow-sm">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-20">
            <!-- Logo -->
            <div class="flex-shrink-0">
                <a href="<?php echo e(route('home')); ?>" class="flex items-center space-x-2">
                    <div class="w-10 h-10 bg-gradient-to-br from-pink-500 to-rose-500 rounded-full flex items-center justify-center">
                        <i class="fas fa-spa text-white text-lg"></i>
                    </div>
                    <span class="text-2xl font-serif font-bold bg-gradient-to-r from-pink-600 to-rose-500 bg-clip-text text-transparent">
                        Bella Nutri
                    </span>
                </a>
            </div>

            <!-- Desktop Navigation -->
            <div class="hidden md:flex items-center space-x-8">
                <a href="<?php echo e(route('home')); ?>" class="text-gray-700 hover:text-pink-600 font-medium transition">
                    Início
                </a>
                <a href="<?php echo e(route('products.index')); ?>" class="text-gray-700 hover:text-pink-600 font-medium transition">
                    Produtos
                </a>
                <a href="#about" class="text-gray-700 hover:text-pink-600 font-medium transition">
                    Sobre
                </a>
                <a href="#contact" class="text-gray-700 hover:text-pink-600 font-medium transition">
                    Contato
                </a>
            </div>

            <!-- Right Side -->
            <div class="hidden md:flex items-center space-x-4">
                <!-- Cart -->
                <a href="<?php echo e(route('cart.index')); ?>" class="relative p-2 text-gray-700 hover:text-pink-600 transition">
                    <i class="fas fa-shopping-bag text-xl"></i>
                    <span id="cart-count" class="absolute -top-1 -right-1 bg-pink-500 text-white text-xs w-5 h-5 rounded-full flex items-center justify-center font-semibold">
                        0
                    </span>
                </a>

                <!-- User Menu -->
                <?php if(auth()->guard()->check()): ?>
                    <a href="/dashboard" class="p-2 text-gray-700 hover:text-pink-600 transition">
                        <i class="fas fa-user text-xl"></i>
                    </a>
                <?php else: ?>
                    <a href="/login" class="px-6 py-2.5 bg-gradient-to-r from-pink-500 to-rose-500 text-white font-semibold rounded-full hover:from-pink-600 hover:to-rose-600 transition transform hover:scale-105 shadow-lg shadow-pink-200">
                        Entrar
                    </a>
                <?php endif; ?>
            </div>

            <!-- Mobile Menu Button -->
            <div class="md:hidden flex items-center space-x-3">
                <a href="<?php echo e(route('cart.index')); ?>" class="relative p-2 text-gray-700">
                    <i class="fas fa-shopping-bag text-xl"></i>
                    <span id="cart-count-mobile" class="absolute -top-1 -right-1 bg-pink-500 text-white text-xs w-5 h-5 rounded-full flex items-center justify-center font-semibold">
                        0
                    </span>
                </a>
                <button id="mobile-menu-btn" class="p-2 text-gray-700">
                    <i class="fas fa-bars text-xl"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div id="mobile-menu" class="hidden md:hidden bg-white border-t border-gray-100">
        <div class="px-4 py-4 space-y-3">
            <a href="<?php echo e(route('home')); ?>" class="block py-2 text-gray-700 hover:text-pink-600 font-medium">
                Início
            </a>
            <a href="<?php echo e(route('products.index')); ?>" class="block py-2 text-gray-700 hover:text-pink-600 font-medium">
                Produtos
            </a>
            <a href="#about" class="block py-2 text-gray-700 hover:text-pink-600 font-medium">
                Sobre
            </a>
            <a href="#contact" class="block py-2 text-gray-700 hover:text-pink-600 font-medium">
                Contato
            </a>
            <?php if(auth()->guard()->guest()): ?>
                <a href="/login" class="block w-full text-center py-3 bg-gradient-to-r from-pink-500 to-rose-500 text-white font-semibold rounded-full">
                    Entrar
                </a>
            <?php endif; ?>
        </div>
    </div>
</nav>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const mobileMenuBtn = document.getElementById('mobile-menu-btn');
    const mobileMenu = document.getElementById('mobile-menu');

    mobileMenuBtn.addEventListener('click', function() {
        mobileMenu.classList.toggle('hidden');
    });
});
</script>
<?php /**PATH C:\Users\fabio\OneDrive\Documentos\katia\suplementos\resources\views/layouts/site-navigation.blade.php ENDPATH**/ ?>