<?php $__env->startSection('title', 'Configurações'); ?>

<?php $__env->startSection('header', 'Configurações'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto">
    <form method="POST" action="<?php echo e(route('admin.settings.update')); ?>">
        <?php echo csrf_field(); ?>

        <!-- Tabs -->
        <div class="bg-white rounded-lg shadow-sm mb-6">
            <div class="border-b">
                <nav class="flex space-x-8 px-6" aria-label="Tabs">
                    <button type="button" onclick="showTab('loja')" id="tab-loja" class="tab-button py-4 px-1 border-b-2 border-blue-500 font-medium text-sm text-blue-600">
                        Loja
                    </button>
                    <button type="button" onclick="showTab('asaas')" id="tab-asaas" class="tab-button py-4 px-1 border-b-2 border-transparent font-medium text-sm text-gray-500 hover:text-gray-700">
                        Asaas
                    </button>
                    <button type="button" onclick="showTab('mercadopago')" id="tab-mercadopago" class="tab-button py-4 px-1 border-b-2 border-transparent font-medium text-sm text-gray-500 hover:text-gray-700">
                        Mercado Pago
                    </button>
                    <button type="button" onclick="showTab('frete')" id="tab-frete" class="tab-button py-4 px-1 border-b-2 border-transparent font-medium text-sm text-gray-500 hover:text-gray-700">
                        Frete
                    </button>
                    <button type="button" onclick="showTab('pagamento')" id="tab-pagamento" class="tab-button py-4 px-1 border-b-2 border-transparent font-medium text-sm text-gray-500 hover:text-gray-700">
                        Pagamento
                    </button>
                </nav>
            </div>
        </div>

        <!-- Tab Content -->
        <div class="space-y-6">
            <!-- Tab Loja -->
            <div id="content-loja" class="tab-content bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold mb-4">Informações da Loja</h3>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Nome da Loja</label>
                        <input type="text" name="store_name" value="<?php echo e($settings['store_name'] ?? config('app.name')); ?>"
                               class="w-full px-4 py-2 border rounded-lg" placeholder="Minha Loja">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">E-mail</label>
                        <input type="email" name="store_email" value="<?php echo e($settings['store_email'] ?? ''); ?>"
                               class="w-full px-4 py-2 border rounded-lg" placeholder="contato@minhaloja.com">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Telefone</label>
                        <input type="text" name="store_phone" value="<?php echo e($settings['store_phone'] ?? ''); ?>"
                               class="w-full px-4 py-2 border rounded-lg" placeholder="(11) 99999-9999">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Descrição</label>
                        <textarea name="store_description" rows="3"
                                  class="w-full px-4 py-2 border rounded-lg"><?php echo e($settings['store_description'] ?? ''); ?></textarea>
                    </div>
                </div>
            </div>

            <!-- Tab Asaas -->
            <div id="content-asaas" class="tab-content bg-white rounded-lg shadow-sm p-6 hidden">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold">Integração com Asaas</h3>
                    <button type="button" onclick="testAsaasConnection()" class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 text-sm">
                        Testar Conexão
                    </button>
                </div>
                <div id="asaas-test-result" class="mb-4 hidden"></div>

                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">API Key *</label>
                        <input type="text" name="asaas_api_key" value="<?php echo e($settings['asaas_api_key'] ?? ''); ?>"
                               class="w-full px-4 py-2 border rounded-lg" placeholder="Sua API Key do Asaas">
                        <p class="text-xs text-gray-500 mt-1">
                            Obtenha sua API Key em: <a href="https://www.asaas.com/" target="_blank" class="text-blue-600 hover:underline">asaas.com</a>
                        </p>
                    </div>
                    <div>
                        <label class="flex items-center">
                            <input type="checkbox" name="asaas_sandbox" <?php echo e(($settings['asaas_sandbox'] ?? '1') == '1' ? 'checked' : ''); ?>

                                   class="w-4 h-4 text-blue-600 rounded">
                            <span class="ml-2 text-sm">Modo Sandbox (Teste)</span>
                        </label>
                        <p class="text-xs text-gray-500 ml-6">Use o sandbox para testes antes de ir para produção</p>
                    </div>
                    <div class="border-t pt-4">
                        <h4 class="font-medium mb-3">Métodos de Pagamento Habilitados</h4>
                        <div class="space-y-2">
                            <label class="flex items-center">
                                <input type="checkbox" name="asaas_pix_enabled" <?php echo e(($settings['asaas_pix_enabled'] ?? '1') == '1' ? 'checked' : ''); ?>

                                       class="w-4 h-4 text-blue-600 rounded">
                                <span class="ml-2 text-sm">PIX</span>
                            </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="asaas_credit_card_enabled" <?php echo e(($settings['asaas_credit_card_enabled'] ?? '1') == '1' ? 'checked' : ''); ?>

                                       class="w-4 h-4 text-blue-600 rounded">
                                <span class="ml-2 text-sm">Cartão de Crédito</span>
                            </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="asaas_boleto_enabled" <?php echo e(($settings['asaas_boleto_enabled'] ?? '1') == '1' ? 'checked' : ''); ?>

                                       class="w-4 h-4 text-blue-600 rounded">
                                <span class="ml-2 text-sm">Boleto</span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tab Mercado Pago -->
            <div id="content-mercadopago" class="tab-content bg-white rounded-lg shadow-sm p-6 hidden">
                <h3 class="text-lg font-semibold mb-4">Integração com Mercado Pago</h3>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Access Token</label>
                        <input type="text" name="mercadopago_access_token" value="<?php echo e($settings['mercadopago_access_token'] ?? ''); ?>"
                               class="w-full px-4 py-2 border rounded-lg" placeholder="Seu Access Token do Mercado Pago">
                    </div>
                    <div>
                        <label class="flex items-center">
                            <input type="checkbox" name="mercadopago_sandbox" <?php echo e(($settings['mercadopago_sandbox'] ?? '1') == '1' ? 'checked' : ''); ?>

                                   class="w-4 h-4 text-blue-600 rounded">
                            <span class="ml-2 text-sm">Modo Sandbox (Teste)</span>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Tab Frete -->
            <div id="content-frete" class="tab-content bg-white rounded-lg shadow-sm p-6 hidden">
                <h3 class="text-lg font-semibold mb-4">Configurações de Frete</h3>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Frete Grátis Acima de (R$)</label>
                        <input type="number" step="0.01" name="free_shipping_threshold" value="<?php echo e($settings['free_shipping_threshold'] ?? ''); ?>"
                               class="w-full px-4 py-2 border rounded-lg" placeholder="247.00">
                        <p class="text-xs text-gray-500 mt-1">Deixe em branco para não oferecer frete grátis</p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Custo Padrão de Frete (R$)</label>
                        <input type="number" step="0.01" name="default_shipping_cost" value="<?php echo e($settings['default_shipping_cost'] ?? '0'); ?>"
                               class="w-full px-4 py-2 border rounded-lg" placeholder="15.00">
                        <p class="text-xs text-gray-500 mt-1">Usado quando não houver cálculo de frete</p>
                    </div>
                </div>
            </div>

            <!-- Tab Pagamento -->
            <div id="content-pagamento" class="tab-content bg-white rounded-lg shadow-sm p-6 hidden">
                <h3 class="text-lg font-semibold mb-4">Configurações de Pagamento</h3>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Máximo de Parcelas</label>
                        <select name="max_installments" class="w-full px-4 py-2 border rounded-lg">
                            <?php for($i = 1; $i <= 12; $i++): ?>
                                <option value="<?php echo e($i); ?>" <?php echo e(($settings['max_installments'] ?? '12') == $i ? 'selected' : ''); ?>>
                                    <?php echo e($i); ?>x
                                </option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Valor Mínimo da Parcela (R$)</label>
                        <input type="number" step="0.01" name="min_installment_value" value="<?php echo e($settings['min_installment_value'] ?? '10'); ?>"
                               class="w-full px-4 py-2 border rounded-lg" placeholder="10.00">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Desconto no PIX (%)</label>
                        <input type="number" step="0.01" name="pix_discount_percentage" value="<?php echo e($settings['pix_discount_percentage'] ?? '0'); ?>"
                               class="w-full px-4 py-2 border rounded-lg" placeholder="5">
                        <p class="text-xs text-gray-500 mt-1">Desconto aplicado automaticamente quando o cliente escolher PIX</p>
                    </div>
                </div>
            </div>

            <!-- Botões -->
            <div class="bg-white rounded-lg shadow-sm p-6 flex justify-end gap-3">
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="px-6 py-2 bg-gray-300 text-gray-700 rounded-lg hover:bg-gray-400 transition">
                    Cancelar
                </a>
                <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">
                    Salvar Configurações
                </button>
            </div>
        </div>
    </form>
</div>

<script>
function showTab(tabName) {
    // Hide all tabs
    document.querySelectorAll('.tab-content').forEach(content => {
        content.classList.add('hidden');
    });

    // Remove active state from all tabs
    document.querySelectorAll('.tab-button').forEach(button => {
        button.classList.remove('border-blue-500', 'text-blue-600');
        button.classList.add('border-transparent', 'text-gray-500');
    });

    // Show selected tab
    document.getElementById('content-' + tabName).classList.remove('hidden');

    // Add active state to selected tab
    const activeTab = document.getElementById('tab-' + tabName);
    activeTab.classList.remove('border-transparent', 'text-gray-500');
    activeTab.classList.add('border-blue-500', 'text-blue-600');
}

async function testAsaasConnection() {
    const resultDiv = document.getElementById('asaas-test-result');
    const apiKey = document.querySelector('input[name="asaas_api_key"]').value;
    const sandbox = document.querySelector('input[name="asaas_sandbox"]').checked;

    if (!apiKey) {
        resultDiv.innerHTML = '<div class="p-4 bg-yellow-100 border border-yellow-400 text-yellow-700 rounded">Informe a API Key primeiro.</div>';
        resultDiv.classList.remove('hidden');
        return;
    }

    resultDiv.innerHTML = '<div class="p-4 bg-blue-100 border border-blue-400 text-blue-700 rounded">Testando conexão...</div>';
    resultDiv.classList.remove('hidden');

    try {
        const response = await fetch('/admin/settings/test-asaas', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({
                api_key: apiKey,
                sandbox: sandbox
            })
        });

        const data = await response.json();

        if (data.success) {
            resultDiv.innerHTML = '<div class="p-4 bg-green-100 border border-green-400 text-green-700 rounded">' + data.message + '</div>';
        } else {
            resultDiv.innerHTML = '<div class="p-4 bg-red-100 border border-red-400 text-red-700 rounded">' + data.message + '</div>';
        }
    } catch (error) {
        resultDiv.innerHTML = '<div class="p-4 bg-red-100 border border-red-400 text-red-700 rounded">Erro ao testar conexão.</div>';
    }
}
</script>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\fabio\OneDrive\Documentos\katia\suplementos\resources\views/admin/settings/index.blade.php ENDPATH**/ ?>