<footer class="bg-gradient-to-br from-pink-50 via-white to-purple-50 text-gray-700">
    <!-- Main Footer -->
    <div class="container mx-auto px-4 py-16">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12">
            <!-- About -->
            <div>
                <div class="flex items-center space-x-2 mb-6">
                    <div class="w-12 h-12 bg-gradient-to-br from-pink-400 via-rose-400 to-pink-500 rounded-2xl flex items-center justify-center shadow-lg">
                        <i class="fas fa-spa text-white text-xl"></i>
                    </div>
                    <span class="text-2xl font-bold bg-gradient-to-r from-pink-600 to-rose-500 bg-clip-text text-transparent font-serif">Bella Nutri</span>
                </div>
                <p class="text-gray-600 mb-6 leading-relaxed">
                    Suplementos premium desenvolvidos especialmente para mulheres que buscam beleza, saúde e bem-estar.
                </p>
                <div class="flex space-x-4">
                    <a href="#" class="w-10 h-10 bg-gradient-to-br from-pink-500 to-rose-500 rounded-full flex items-center justify-center text-white hover:shadow-lg hover:shadow-pink-200 transition-all duration-300">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a href="#" class="w-10 h-10 bg-gradient-to-br from-pink-500 to-rose-500 rounded-full flex items-center justify-center text-white hover:shadow-lg hover:shadow-pink-200 transition-all duration-300">
                        <i class="fab fa-instagram"></i>
                    </a>
                    <a href="#" class="w-10 h-10 bg-gradient-to-br from-pink-500 to-rose-500 rounded-full flex items-center justify-center text-white hover:shadow-lg hover:shadow-pink-200 transition-all duration-300">
                        <i class="fab fa-whatsapp"></i>
                    </a>
                    <a href="#" class="w-10 h-10 bg-gradient-to-br from-pink-500 to-rose-500 rounded-full flex items-center justify-center text-white hover:shadow-lg hover:shadow-pink-200 transition-all duration-300">
                        <i class="fab fa-tiktok"></i>
                    </a>
                </div>
            </div>

            <!-- Quick Links -->
            <div>
                <h3 class="font-serif font-semibold text-lg mb-6 text-gray-800">Navegação</h3>
                <ul class="space-y-3">
                    <li><a href="<?php echo e(route('home')); ?>" class="text-gray-600 hover:text-pink-600 transition flex items-center"><i class="fas fa-chevron-right text-xs mr-2 text-pink-400"></i>Início</a></li>
                    <li><a href="<?php echo e(route('products.index')); ?>" class="text-gray-600 hover:text-pink-600 transition flex items-center"><i class="fas fa-chevron-right text-xs mr-2 text-pink-400"></i>Produtos</a></li>
                    <li><a href="#about" class="text-gray-600 hover:text-pink-600 transition flex items-center"><i class="fas fa-chevron-right text-xs mr-2 text-pink-400"></i>Sobre</a></li>
                    <li><a href="#contact" class="text-gray-600 hover:text-pink-600 transition flex items-center"><i class="fas fa-chevron-right text-xs mr-2 text-pink-400"></i>Contato</a></li>
                </ul>
            </div>

            <!-- Categories -->
            <div>
                <h3 class="font-serif font-semibold text-lg mb-6 text-gray-800">Categorias</h3>
                <ul class="space-y-3">
                    <li><a href="#" class="text-gray-600 hover:text-pink-600 transition flex items-center"><i class="fas fa-leaf text-xs mr-2 text-pink-400"></i>Proteínas</a></li>
                    <li><a href="#" class="text-gray-600 hover:text-pink-600 transition flex items-center"><i class="fas fa-leaf text-xs mr-2 text-pink-400"></i>Colágeno</a></li>
                    <li><a href="#" class="text-gray-600 hover:text-pink-600 transition flex items-center"><i class="fas fa-leaf text-xs mr-2 text-pink-400"></i>Vitaminas</a></li>
                    <li><a href="#" class="text-gray-600 hover:text-pink-600 transition flex items-center"><i class="fas fa-leaf text-xs mr-2 text-pink-400"></i>Termogênicos</a></li>
                    <li><a href="#" class="text-gray-600 hover:text-pink-600 transition flex items-center"><i class="fas fa-leaf text-xs mr-2 text-pink-400"></i>Ômega 3</a></li>
                </ul>
            </div>

            <!-- Contact -->
            <div id="contact">
                <h3 class="font-serif font-semibold text-lg mb-6 text-gray-800">Contato</h3>
                <ul class="space-y-4">
                    <li class="flex items-start">
                        <div class="w-10 h-10 bg-pink-100 rounded-full flex items-center justify-center mr-3 flex-shrink-0">
                            <i class="fas fa-map-marker-alt text-pink-500"></i>
                        </div>
                        <div>
                            <p class="font-medium text-gray-800">Endereço</p>
                            <p class="text-sm text-gray-600">Rua das Flores, 123 - Jardins</p>
                        </div>
                    </li>
                    <li class="flex items-center">
                        <div class="w-10 h-10 bg-pink-100 rounded-full flex items-center justify-center mr-3 flex-shrink-0">
                            <i class="fas fa-phone text-pink-500"></i>
                        </div>
                        <div>
                            <p class="font-medium text-gray-800">(11) 99999-9999</p>
                        </div>
                    </li>
                    <li class="flex items-center">
                        <div class="w-10 h-10 bg-pink-100 rounded-full flex items-center justify-center mr-3 flex-shrink-0">
                            <i class="fas fa-envelope text-pink-500"></i>
                        </div>
                        <div>
                            <p class="font-medium text-gray-800">contato@bellanutri.com.br</p>
                        </div>
                    </li>
                    <li class="flex items-center">
                        <div class="w-10 h-10 bg-green-100 rounded-full flex items-center justify-center mr-3 flex-shrink-0">
                            <i class="fab fa-whatsapp text-green-500"></i>
                        </div>
                        <div>
                            <p class="font-medium text-gray-800">(11) 99999-9999</p>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Payment Methods -->
    <div class="bg-white border-t border-pink-100 py-8">
        <div class="container mx-auto px-4">
            <div class="flex flex-col items-center">
                <p class="text-gray-600 mb-4 text-sm font-medium">Formas de Pagamento</p>
                <div class="flex flex-wrap items-center justify-center gap-4">
                    <div class="bg-gray-50 px-4 py-2 rounded-lg">
                        <i class="fab fa-cc-visa text-2xl text-blue-600"></i>
                    </div>
                    <div class="bg-gray-50 px-4 py-2 rounded-lg">
                        <i class="fab fa-cc-mastercard text-2xl text-orange-500"></i>
                    </div>
                    <div class="bg-gray-50 px-4 py-2 rounded-lg">
                        <i class="fab fa-cc-amex text-2xl text-blue-500"></i>
                    </div>
                    <div class="bg-gray-50 px-4 py-2 rounded-lg">
                        <i class="fab fa-pix text-2xl text-green-600">PIX</i>
                    </div>
                    <div class="bg-gray-50 px-4 py-2 rounded-lg">
                        <i class="fas fa-barcode text-2xl text-gray-600"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Security Badges -->
    <div class="bg-gradient-to-r from-pink-50 to-purple-50 py-6 border-t border-pink-100">
        <div class="container mx-auto px-4">
            <div class="flex flex-wrap items-center justify-center gap-8 text-sm text-gray-600">
                <div class="flex items-center space-x-2">
                    <i class="fas fa-shield-alt text-2xl text-pink-500"></i>
                    <span>Compra 100% Segura</span>
                </div>
                <div class="flex items-center space-x-2">
                    <i class="fas fa-lock text-2xl text-pink-500"></i>
                    <span>Dados Protegidos</span>
                </div>
                <div class="flex items-center space-x-2">
                    <i class="fas fa-certificate text-2xl text-pink-500"></i>
                    <span>Produtos Originais</span>
                </div>
                <div class="flex items-center space-x-2">
                    <i class="fas fa-truck text-2xl text-pink-500"></i>
                    <span>Entrega Garantida</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Copyright -->
    <div class="bg-gradient-to-r from-pink-600 to-rose-500 text-white py-6">
        <div class="container mx-auto px-4 text-center">
            <p class="font-medium">&copy; <?php echo e(date('Y')); ?> Bella Nutri. Todos os direitos reservados.</p>
            <p class="text-pink-100 text-sm mt-2">Feito com <i class="fas fa-heart text-rose-200"></i> para mulheres incríveis</p>
        </div>
    </div>
</footer>
<?php /**PATH C:\Users\fabio\OneDrive\Documentos\katia\suplementos\resources\views/partials/footer.blade.php ENDPATH**/ ?>