<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ProductController as AdminProductController;
use App\Http\Controllers\Admin\ComboController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\VariantController;
use App\Http\Controllers\WebhookController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\HomeController;
use Illuminate\Support\Facades\Route;

// Rotas públicas
Route::get('/', [HomeController::class, 'index'])->name('home');

// Produtos (público)
Route::get('/produtos', [ProductController::class, 'index'])->name('products.index');
Route::get('/produto/{slug}', [ProductController::class, 'show'])->name('products.show');

// Rotas do painel administrativo
Route::prefix('admin')->name('admin.')->middleware(['auth', 'admin'])->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

    // Produtos
    Route::resource('products', AdminProductController::class);
    Route::post('products/{product}/toggle-active', [AdminProductController::class, 'toggleActive'])->name('products.toggle-active');
    Route::post('products/{product}/toggle-featured', [AdminProductController::class, 'toggleFeatured'])->name('products.toggle-featured');
    Route::post('products/{product}/images/{image}/set-main', [AdminProductController::class, 'setMainImage'])->name('products.images.set-main');
    Route::get('products-import', [AdminProductController::class, 'import'])->name('products.import');
    Route::post('products-import', [AdminProductController::class, 'processImport'])->name('products.import.process');
    Route::get('products-import/template', [AdminProductController::class, 'downloadTemplate'])->name('products.import.template');

    // Combos
    Route::resource('combos', ComboController::class);
    Route::post('combos/{combo}/toggle-active', [ComboController::class, 'toggleActive'])->name('combos.toggle-active');
    Route::post('combos/{combo}/toggle-featured', [ComboController::class, 'toggleFeatured'])->name('combos.toggle-featured');

    // Pedidos
    Route::resource('orders', OrderController::class)->only(['index', 'show', 'update']);
    Route::post('orders/{order}/payment-status', [OrderController::class, 'updatePaymentStatus'])->name('orders.payment-status');
    Route::get('orders/{order}/print', [OrderController::class, 'print'])->name('orders.print');

    // Configurações
    Route::get('/settings', [SettingController::class, 'index'])->name('settings.index');
    Route::post('/settings', [SettingController::class, 'update'])->name('settings.update');
    Route::post('/settings/test-asaas', [SettingController::class, 'testAsaasConnection'])->name('settings.test-asaas');

    // Cupons
    Route::resource('coupons', CouponController::class);

    // Variantes
    Route::resource('variants', VariantController::class);
});

// Rotas do Breeze (autenticação)
Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Webhooks (sem CSRF, verificação por assinatura)
Route::post('/webhook/asaas', [WebhookController::class, 'asaas'])->name('webhook.asaas')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);

// Carrinho de compras (público, sem autenticação)
Route::get('/carrinho', [CartController::class, 'index'])->name('cart.index');
Route::post('/carrinho/adicionar', [CartController::class, 'add'])->name('cart.add');
Route::post('/carrinho/atualizar', [CartController::class, 'update'])->name('cart.update');
Route::post('/carrinho/remover', [CartController::class, 'remove'])->name('cart.remove');
Route::post('/carrinho/limpar', [CartController::class, 'clear'])->name('cart.clear');
Route::post('/carrinho/cupom', [CartController::class, 'applyCoupon'])->name('cart.apply-coupon');
Route::post('/carrinho/cupom/remover', [CartController::class, 'removeCoupon'])->name('cart.remove-coupon');
Route::get('/carrinho/api', [CartController::class, 'get'])->name('cart.api');

// Checkout (requer autenticação)
Route::prefix('checkout')->name('checkout.')->middleware(['auth'])->group(function () {
    Route::get('/', [CheckoutController::class, 'index'])->name('index');
    Route::post('/', [CheckoutController::class, 'process'])->name('process');
    Route::get('/sucesso/{orderNumber}', [CheckoutController::class, 'success'])->name('success');
    Route::get('/cep/{cep}', [CheckoutController::class, 'consultCep'])->name('cep');
});

require __DIR__.'/auth.php';
