@extends('layouts.app')

@section('title', 'Depoimentos - Suplementos Store')

@section('content')
<!-- Page Header -->
<section class="bg-gradient-to-r from-primary-700 to-primary-900 text-white py-12">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto text-center">
            <h1 class="text-3xl md:text-4xl font-bold mb-4">Depoimentos</h1>
            <p class="text-primary-100 text-lg">
                Veja o que nossos clientes dizem sobre nós
            </p>
        </div>
    </div>
</section>

<!-- Testimonials Grid -->
<section class="py-16">
    <div class="container mx-auto px-4">
        @if($testimonials->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                @foreach($testimonials as $testimonial)
                    <div class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow">
                        <!-- Rating -->
                        <div class="flex items-center mb-4">
                            @for($i = 1; $i <= 5; $i++)
                                <i class="fas fa-star {{ $i <= $testimonial->rating ? 'text-yellow-400' : 'text-gray-300' }}"></i>
                            @endfor
                        </div>

                        <!-- Comment -->
                        <p class="text-gray-600 mb-6 italic">"{{ $testimonial->comment }}"</p>

                        <!-- Author -->
                        <div class="flex items-center">
                            @if($testimonial->photo_url)
                                <img src="{{ $testimonial->photo_url }}" alt="{{ $testimonial->name }}"
                                     class="w-12 h-12 rounded-full object-cover mr-4">
                            @else
                                <div class="w-12 h-12 bg-primary-100 rounded-full flex items-center justify-center mr-4">
                                    <i class="fas fa-user text-primary-600"></i>
                                </div>
                            @endif
                            <div>
                                <h4 class="font-semibold text-gray-800">{{ $testimonial->name }}</h4>
                                <p class="text-sm text-gray-500">Cliente verificado</p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            @if($testimonials->hasPages())
                <div class="mt-12">
                    {{ $testimonials->links() }}
                </div>
            @endif
        @else
            <div class="text-center py-12">
                <i class="fas fa-comment-slash text-gray-300 text-6xl mb-4"></i>
                <h3 class="text-xl font-semibold text-gray-800 mb-2">Nenhum depoimento disponível</h3>
                <p class="text-gray-600">Seja o primeiro a deixar um depoimento!</p>
            </div>
        @endif
    </div>
</section>
@endsection
