@extends('layouts.app')

@section('title', $product->meta_title ?? "$product->name - Suplementos Store")

@section('content')
<!-- Breadcrumb -->
<nav class="bg-gray-100 py-3">
    <div class="container mx-auto px-4">
        <ol class="flex items-center space-x-2 text-sm">
            <li><a href="{{ route('home') }}" class="text-gray-600 hover:text-primary-600"><i class="fas fa-home"></i></a></li>
            <li class="text-gray-400">/</li>
            <li><a href="{{ route('products.index') }}" class="text-gray-600 hover:text-primary-600">Produtos</a></li>
            @if($product->category)
                <li class="text-gray-400">/</li>
                <li><a href="{{ route('categories.show', $product->category->slug) }}" class="text-gray-600 hover:text-primary-600">{{ $product->category->name }}</a></li>
            @endif
            <li class="text-gray-400">/</li>
            <li class="text-gray-800 font-medium truncate">{{ $product->name }}</li>
        </ol>
    </div>
</nav>

<!-- Product Detail -->
<section class="py-12">
    <div class="container mx-auto px-4">
        <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 p-6 lg:p-10">
                <!-- Product Images & Video -->
                <div>
                    <!-- Main Image -->
                    <div class="relative aspect-square rounded-xl overflow-hidden bg-gray-100 mb-4">
                        @if($product->images->where('is_main', true)->first())
                            <img id="mainImage" src="{{ $product->images->where('is_main', true)->first()->url }}"
                                 alt="{{ $product->images->where('is_main', true)->first()->alt_text ?? $product->name }}"
                                 class="w-full h-full object-cover">
                        @elseif($product->images->first())
                            <img id="mainImage" src="{{ $product->images->first()->url }}"
                                 alt="{{ $product->images->first()->alt_text ?? $product->name }}"
                                 class="w-full h-full object-cover">
                        @else
                            <div class="w-full h-full bg-gray-200 flex items-center justify-center">
                                <i class="fas fa-image text-gray-400 text-6xl"></i>
                            </div>
                        @endif

                        @if($product->has_discount)
                            <div class="absolute top-4 left-4">
                                <span class="bg-secondary-500 text-white font-bold px-4 py-2 rounded-full text-lg">
                                    -{{ $product->discount_percentage_calculated }}%
                                </span>
                            </div>
                        @endif
                    </div>

                    <!-- Video -->
                    @if($product->video_url)
                        <div class="rounded-xl overflow-hidden bg-gray-100 mb-4">
                            <iframe width="100%" height="400" src="{{ $product->video_url }}"
                                    frameborder="0" allowfullscreen class="w-full"></iframe>
                        </div>
                    @endif

                    <!-- Thumbnail Gallery -->
                    @if($product->images->count() > 1)
                        <div class="flex space-x-3 overflow-x-auto pb-2">
                            @foreach($product->images as $image)
                                <button onclick="changeMainImage('{{ $image->url }}')"
                                        class="flex-shrink-0 w-20 h-20 rounded-lg overflow-hidden border-2 {{ $image->is_main ? 'border-primary-600' : 'border-gray-200' }} hover:border-primary-600 transition">
                                    <img src="{{ $image->url }}" alt="{{ $image->alt_text }}"
                                         class="w-full h-full object-cover">
                                </button>
                            @endforeach
                        </div>
                    @endif
                </div>

                <!-- Product Info -->
                <div>
                    <!-- Category -->
                    @if($product->category)
                        <span class="inline-block px-3 py-1 bg-primary-100 text-primary-700 rounded-full text-sm font-medium mb-4">
                            {{ $product->category->name }}
                        </span>
                    @endif

                    <!-- Title -->
                    <h1 class="text-3xl font-bold text-gray-800 mb-4">{{ $product->name }}</h1>

                    <!-- Rating -->
                    <div class="flex items-center space-x-2 mb-4">
                        <div class="flex text-yellow-400">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star-half-alt"></i>
                        </div>
                        <span class="text-gray-600">(4.5)</span>
                    </div>

                    <!-- Price -->
                    <div class="mb-6">
                        @if($product->has_discount)
                            <div class="flex items-center space-x-3">
                                <span class="text-2xl text-gray-400 line-through">
                                    R$ {{ number_format($product->price, 2, ',', '.') }}
                                </span>
                                <span class="text-4xl font-bold text-secondary-600">
                                    R$ {{ number_format($product->final_price, 2, ',', '.') }}
                                </span>
                            </div>
                            <p class="text-green-600 font-medium mt-1">
                                <i class="fas fa-check-circle mr-1"></i>
                                Você economiza R$ {{ number_format($product->price - $product->final_price, 2, ',', '.') }}
                            </p>
                        @else
                            <span class="text-4xl font-bold text-primary-700">
                                R$ {{ number_format($product->price, 2, ',', '.') }}
                            </span>
                        @endif

                        @if($product->pix_price && $product->pix_price < ($product->final_price ?? $product->price))
                            <div class="mt-2 p-3 bg-green-50 rounded-lg border border-green-200">
                                <p class="text-green-800 font-semibold">
                                    PIX: R$ {{ number_format($product->pix_price, 2, ',', '.') }}
                                </p>
                                <p class="text-xs text-green-600">
                                    Economize R$ {{ number_format(($product->final_price ?? $product->price) - $product->pix_price, 2, ',', '.') }}
                                </p>
                            </div>
                        @endif

                        <p class="text-gray-500 text-sm mt-2">
                            <i class="fas fa-credit-card mr-1"></i>
                            @if($product->max_installments)
                                ou em até {{ $product->max_installments }}x sem juros
                            @else
                                ou em até 12x sem juros
                            @endif
                        </p>
                    </div>

                    <!-- Short Description -->
                    @if($product->short_description)
                        <p class="text-gray-600 mb-6">{{ $product->short_description }}</p>
                    @endif

                    <!-- Variant Selection -->
                    @if($availableVariants && $availableVariants->count() > 0 && $product->variants && $product->variants->count() > 0)
                        <form id="addToCartForm" action="{{ route('cart.add') }}" method="POST" class="space-y-4 mb-6">
                            @csrf
                            <input type="hidden" name="type" value="product">
                            <input type="hidden" name="id" value="{{ $product->id }}">
                            <input type="hidden" name="variant" value="" id="selectedVariant">

                            @foreach($availableVariants as $type => $variants)
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        {{ ucfirst($type) }}
                                    </label>
                                    <div class="flex flex-wrap gap-2">
                                        @foreach($variants as $variant)
                                            @php
                                                $productVariant = $product->variants->where('variant_id', $variant->id)->first();
                                            @endphp
                                            @if($productVariant && $productVariant->stock > 0)
                                                <button type="button"
                                                        onclick="selectVariant('{{ $type }}', '{{ $variant->name }}', this)"
                                                        class="variant-btn px-4 py-2 border rounded-lg hover:border-primary-400 transition"
                                                        data-type="{{ $type }}">
                                                    {{ $variant->name }}
                                                </button>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                            @endforeach

                            <!-- Quantity & Add to Cart -->
                            <div class="flex flex-col sm:flex-row space-y-4 sm:space-y-0 sm:space-x-4">
                                <div class="flex items-center border border-gray-300 rounded-lg">
                                    <button onclick="decreaseQty()" class="px-4 py-3 text-gray-600 hover:bg-gray-100 transition">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    <input type="number" name="quantity" value="1" min="1"
                                           class="w-16 text-center border-0 focus:outline-none" id="quantity">
                                    <button onclick="increaseQty()" class="px-4 py-3 text-gray-600 hover:bg-gray-100 transition">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                                <button type="submit" class="flex-1 py-3 bg-secondary-500 hover:bg-secondary-600 text-white font-bold rounded-lg transition transform hover:scale-105">
                                    <i class="fas fa-shopping-cart mr-2"></i>Adicionar ao Carrinho
                                </button>
                            </div>
                        </form>
                    @else
                        <!-- Simple Add to Cart (no variants) -->
                        <form id="addToCartForm" action="{{ route('cart.add') }}" method="POST" class="mb-6">
                            @csrf
                            <input type="hidden" name="type" value="product">
                            <input type="hidden" name="id" value="{{ $product->id }}">
                            <div class="flex flex-col sm:flex-row space-y-4 sm:space-y-0 sm:space-x-4">
                                <div class="flex items-center border border-gray-300 rounded-lg">
                                    <button onclick="decreaseQty()" class="px-4 py-3 text-gray-600 hover:bg-gray-100 transition">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    <input type="number" name="quantity" value="1" min="1" max="{{ $product->stock ?? 99 }}"
                                           class="w-16 text-center border-0 focus:outline-none" id="quantity">
                                    <button onclick="increaseQty()" class="px-4 py-3 text-gray-600 hover:bg-gray-100 transition">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                                <button type="submit" class="flex-1 py-3 bg-secondary-500 hover:bg-secondary-600 text-white font-bold rounded-lg transition transform hover:scale-105">
                                    <i class="fas fa-shopping-cart mr-2"></i>Adicionar ao Carrinho
                                </button>
                            </div>
                        </form>
                    @endif

                    <!-- Trust Badges -->
                    <div class="grid grid-cols-3 gap-4 pt-6 border-t">
                        <div class="text-center">
                            <i class="fas fa-truck text-2xl text-primary-600 mb-2"></i>
                            <p class="text-xs text-gray-600">Entrega Rápida</p>
                        </div>
                        <div class="text-center">
                            <i class="fas fa-shield-alt text-2xl text-primary-600 mb-2"></i>
                            <p class="text-xs text-gray-600">Compra Segura</p>
                        </div>
                        <div class="text-center">
                            <i class="fas fa-undo text-2xl text-primary-600 mb-2"></i>
                            <p class="text-xs text-gray-600">Devolução Fácil</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Kits/Combos Section -->
            @if($combos && $combos->count() > 0)
                <div class="border-t p-6 lg:p-10 bg-gray-50">
                    <h2 class="text-2xl font-bold text-gray-800 mb-6">
                        <i class="fas fa-box-open mr-2 text-primary-600"></i>
                        Kits com este produto
                    </h2>
                    <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
                        @foreach($combos as $combo)
                            <div class="bg-white rounded-xl shadow-sm overflow-hidden hover:shadow-md transition">
                                <div class="relative">
                                    @if($combo->image)
                                        <img src="{{ Storage::url($combo->image) }}" alt="{{ $combo->name }}"
                                             class="w-full h-48 object-cover">
                                    @else
                                        <div class="w-full h-48 bg-gray-200 flex items-center justify-center">
                                            <i class="fas fa-boxes text-gray-400 text-4xl"></i>
                                        </div>
                                    @endif
                                    @if($combo->original_price && $combo->original_price > $combo->price)
                                        <span class="absolute top-3 left-3 bg-red-500 text-white text-sm font-bold px-2 py-1 rounded">
                                            -{{ $combo->discount_percentage }}%
                                        </span>
                                    @endif
                                </div>
                                <div class="p-4">
                                    <h3 class="font-bold text-gray-800 mb-2">{{ $combo->name }}</h3>
                                    <div class="text-sm text-gray-600 mb-3">
                                        <p class="font-medium">Contém:</p>
                                        <ul class="list-disc list-inside">
                                            @foreach($combo->items as $item)
                                                <li>{{ $item->product->name }} ({{ $item->quantity }}x)</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                    <div class="mb-3">
                                        @if($combo->original_price && $combo->original_price > $combo->price)
                                            <p class="text-gray-400 line-through text-sm">R$ {{ number_format($combo->original_price, 2, ',', '.') }}</p>
                                        @endif
                                        <p class="text-xl font-bold text-green-600">R$ {{ number_format($combo->price, 2, ',', '.') }}</p>
                                        @if($combo->pix_price)
                                            <p class="text-sm text-green-600">Pix: R$ {{ number_format($combo->pix_price, 2, ',', '.') }}</p>
                                        @endif
                                    </div>
                                    <form action="{{ route('cart.add') }}" method="POST" class="flex gap-2">
                                        @csrf
                                        <input type="hidden" name="type" value="combo">
                                        <input type="hidden" name="id" value="{{ $combo->id }}">
                                        <input type="hidden" name="quantity" value="1">
                                        <button type="submit" class="flex-1 py-2 bg-primary-600 text-white rounded-lg hover:bg-primary-700 text-sm font-medium">
                                            Adicionar Kit
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Product Tabs -->
            <div class="border-t">
                <div class="border-b">
                    <div class="container mx-auto px-4 flex">
                        <button onclick="showTab('description')" id="tab-description" class="px-6 py-4 font-semibold text-primary-600 border-b-2 border-primary-600">
                            Descrição
                        </button>
                        @if($product->features->count() > 0)
                        <button onclick="showTab('features')" id="tab-features" class="px-6 py-4 font-semibold text-gray-600 hover:text-primary-600">
                            Benefícios
                        </button>
                        @endif
                        @if($product->usage_instructions || $product->nutrition_info)
                        <button onclick="showTab('nutrition')" id="tab-nutrition" class="px-6 py-4 font-semibold text-gray-600 hover:text-primary-600">
                            Informações Nutricionais
                        </button>
                        @endif
                        <button onclick="showTab('faq')" id="tab-faq" class="px-6 py-4 font-semibold text-gray-600 hover:text-primary-600">
                            FAQ
                        </button>
                    </div>
                </div>

                <div class="container mx-auto px-4 py-8">
                    <!-- Description Tab -->
                    <div id="content-description" class="tab-content">
                        <div class="prose max-w-none">
                            {!! $product->description !!}
                        </div>
                    </div>

                    <!-- Features Tab -->
                    @if($product->features->count() > 0)
                    <div id="content-features" class="tab-content hidden">
                        <ul class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            @foreach($product->features as $feature)
                                <li class="flex items-start">
                                    <i class="fas fa-check-circle text-green-500 mt-1 mr-3"></i>
                                    <span>{{ $feature->feature }}</span>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    <!-- Nutrition Tab -->
                    @if($product->usage_instructions || $product->nutrition_info)
                    <div id="content-nutrition" class="tab-content hidden">
                        @if($product->nutrition_info)
                            <div class="prose max-w-none">
                                {!! $product->nutrition_info !!}
                            </div>
                        @endif
                        @if($product->usage_instructions)
                            <div class="bg-blue-50 border-l-4 border-blue-500 p-4">
                                <h4 class="font-semibold text-blue-800 mb-2">Modo de Usar</h4>
                                <p class="text-blue-700">{{ $product->usage_instructions }}</p>
                            </div>
                        @endif
                    </div>
                    @endif

                    <!-- FAQ Tab -->
                    <div id="content-faq" class="tab-content hidden">
                        <div class="space-y-4">
                            <div class="border-b pb-4">
                                <h3 class="font-medium text-gray-800 mb-2">Como devo tomar este produto?</h3>
                                <p class="text-gray-600 text-sm">Siga as instruções na embalagem ou consulte um nutricionista.</p>
                            </div>
                            <div class="border-b pb-4">
                                <h3 class="font-medium text-gray-800 mb-2">Qual o prazo de entrega?</h3>
                                <p class="text-gray-600 text-sm">Enviamos para todo o Brasil. O prazo varia de 1 a 10 dias úteis dependendo da região.</p>
                            </div>
                            <div class="border-b pb-4">
                                <h3 class="font-medium text-gray-800 mb-2">Os produtos são originais?</h3>
                                <p class="text-gray-600 text-sm">Sim, todos os produtos são 100% originais e diretos da distribuidora.</p>
                            </div>
                            <div class="border-b pb-4">
                                <h3 class="font-medium text-gray-800 mb-2">Quais as formas de pagamento?</h3>
                                <p class="text-gray-600 text-sm">Aceitamos PIX (com desconto), cartão de crédito em até 12x e boleto bancário.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Related Products -->
        @if($relatedProducts->count() > 0)
        <section class="mt-16">
            <h2 class="text-2xl font-bold text-gray-800 mb-8">Produtos Relacionados</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @foreach($relatedProducts as $relatedProduct)
                    @include('partials.product-card', ['product' => $relatedProduct])
                @endforeach
            </div>
        </section>
        @endif
    </div>
</section>

@push('scripts')
<script>
let maxQuantity = {{ $product->stock ?? 99 }};
let selectedVariants = {};

function increaseQty() {
    const input = document.getElementById('quantity');
    if (parseInt(input.value) < maxQuantity) {
        input.value = parseInt(input.value) + 1;
    }
}

function decreaseQty() {
    const input = document.getElementById('quantity');
    if (parseInt(input.value) > 1) {
        input.value = parseInt(input.value) - 1;
    }
}

function selectVariant(type, value, button) {
    // Remove seleção anterior do mesmo tipo
    document.querySelectorAll('.variant-btn[data-type="' + type + '"]').forEach(btn => {
        btn.classList.remove('border-primary-600', 'bg-primary-50', 'text-primary-600');
    });

    // Adiciona seleção
    button.classList.add('border-primary-600', 'bg-primary-50', 'text-primary-600');
    selectedVariants[type] = value;

    // Atualiza o input hidden
    const variantInput = document.getElementById('selectedVariant');
    if (variantInput) {
        variantInput.value = JSON.stringify(selectedVariants);
    }
}

function changeMainImage(url) {
    document.getElementById('mainImage').src = url;
}

function showTab(tabName) {
    // Hide all tab contents
    document.querySelectorAll('.tab-content').forEach(content => {
        content.classList.add('hidden');
    });

    // Remove active state from all tabs
    document.querySelectorAll('[id^="tab-"]').forEach(tab => {
        tab.classList.remove('text-primary-600', 'border-b-2', 'border-primary-600');
        tab.classList.add('text-gray-600');
    });

    // Show selected tab content
    const content = document.getElementById('content-' + tabName);
    if (content) {
        content.classList.remove('hidden');
    }

    // Add active state to selected tab
    const activeTab = document.getElementById('tab-' + tabName);
    if (activeTab) {
        activeTab.classList.remove('text-gray-600');
        activeTab.classList.add('text-primary-600', 'border-b-2', 'border-primary-600');
    }
}
</script>
@endpush
@endsection
