@props(['product'])

@if(!$product)
    <!-- Produto não disponível -->
@else
<div class="bg-white rounded-3xl shadow-md overflow-hidden group hover:shadow-2xl transition-all duration-500 card-hover border border-pink-100/50">
    <!-- Badge -->
    @if($product->has_discount)
        <div class="absolute top-4 left-4 z-10">
            <span class="bg-gradient-to-r from-rose-500 to-pink-500 text-white text-xs font-bold px-4 py-2 rounded-full shadow-lg">
                -{{ $product->discount_percentage_calculated ?? 0 }}%
            </span>
        </div>
    @elseif($product->is_featured)
        <div class="absolute top-4 left-4 z-10">
            <span class="bg-gradient-to-r from-purple-500 to-pink-500 text-white text-xs font-bold px-4 py-2 rounded-full shadow-lg">
                <i class="fas fa-star mr-1"></i>Destaque
            </span>
        </div>
    @endif

    <!-- Image -->
    <div class="relative overflow-hidden aspect-square bg-gradient-to-br from-pink-50 to-rose-50">
        @if($product->images && $product->images->where('is_main', true)->first())
            <img src="{{ $product->images->where('is_main', true)->first()->url }}"
                 alt="{{ $product->images->where('is_main', true)->first()->alt_text ?? $product->name }}"
                 class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
        @elseif($product->images && $product->images->first())
            <img src="{{ $product->images->first()->url }}"
                 alt="{{ $product->images->first()->alt_text ?? $product->name }}"
                 class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
        @else
            <div class="w-full h-full flex items-center justify-center">
                <div class="text-center">
                    <div class="w-16 h-16 bg-gradient-to-br from-pink-200 to-rose-200 rounded-full flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-spa text-pink-400 text-2xl"></i>
                    </div>
                    <p class="text-pink-300 text-sm">Bella Nutri</p>
                </div>
            </div>
        @endif

        <!-- Quick Actions Overlay -->
        <div class="absolute inset-0 bg-gradient-to-t from-pink-900/70 via-pink-900/30 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-end justify-center pb-6">
            <div class="flex space-x-3">
                <a href="{{ route('products.show', $product->slug) }}"
                   class="w-12 h-12 bg-white rounded-full flex items-center justify-center text-pink-600 hover:bg-pink-500 hover:text-white transition-all duration-300 shadow-lg transform hover:scale-110">
                    <i class="fas fa-eye"></i>
                </a>
                <button onclick="addToCart('{{ $product->slug }}')"
                        class="w-12 h-12 bg-white rounded-full flex items-center justify-center text-pink-600 hover:bg-pink-500 hover:text-white transition-all duration-300 shadow-lg transform hover:scale-110">
                    <i class="fas fa-shopping-bag"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- Content -->
    <div class="p-5">
        <!-- Category -->
        @if($product->category && $product->category->name)
            <span class="inline-block px-3 py-1 bg-gradient-to-r from-pink-100 to-rose-100 text-pink-700 rounded-full text-xs font-semibold mb-3">
                {{ $product->category->name }}
            </span>
        @endif

        <!-- Name -->
        <h3 class="font-semibold text-gray-800 mb-3 line-clamp-2 min-h-[48px] flex items-center">
            <a href="{{ route('products.show', $product->slug) }}" class="hover:text-pink-600 transition">
                {{ $product->name }}
            </a>
        </h3>

        <!-- Price -->
        <div class="mb-4">
            @if($product->has_discount)
                <div class="flex items-center space-x-3">
                    <span class="text-sm text-gray-400 line-through">
                        R$ {{ number_format($product->price, 2, ',', '.') }}
                    </span>
                    <span class="text-2xl font-bold gradient-text">
                        R$ {{ number_format($product->final_price ?? $product->price, 2, ',', '.') }}
                    </span>
                </div>
            @else
                <span class="text-2xl font-bold gradient-text">
                    R$ {{ number_format($product->price, 2, ',', '.') }}
                </span>
            @endif
        </div>

        <!-- Buttons -->
        <div class="flex space-x-2">
            <a href="{{ route('products.show', $product->slug) }}"
               class="flex-1 text-center py-3 px-4 border-2 border-pink-200 text-pink-600 rounded-2xl hover:bg-pink-50 hover:border-pink-300 transition-all duration-300 text-sm font-semibold">
                Ver Detalhes
            </a>
            <button onclick="addToCart('{{ $product->slug }}')"
                    class="flex-1 py-3 px-4 bg-gradient-to-r from-pink-500 to-rose-500 text-white rounded-2xl hover:from-pink-600 hover:to-rose-600 transition-all duration-300 text-sm font-semibold shadow-lg transform hover:scale-105">
                <i class="fas fa-heart mr-1"></i> Adicionar
            </button>
        </div>
    </div>
</div>
@endif
