<!-- Top Bar -->
<div class="bg-gradient-to-r from-pink-600 via-rose-500 to-pink-600 text-white text-sm py-2">
    <div class="container mx-auto px-4 flex justify-between items-center">
        <div class="flex items-center space-x-4">
            <span><i class="fas fa-truck mr-2"></i>Frete grátis acima de R$ 150</span>
            <span class="hidden md:inline"><i class="fas fa-gift mr-2"></i>Brindes exclusivos</span>
        </div>
        <div class="flex items-center space-x-3">
            <a href="https://wa.me/5500000000000" target="_blank" class="hover:text-pink-200 transition">
                <i class="fab fa-whatsapp text-lg"></i>
            </a>
            <a href="#" class="hover:text-pink-200 transition">
                <i class="fab fa-instagram text-lg"></i>
            </a>
            <a href="#" class="hover:text-pink-200 transition">
                <i class="fab fa-tiktok text-lg"></i>
            </a>
        </div>
    </div>
</div>

<!-- Main Header -->
<header class="bg-white/80 backdrop-blur-md shadow-sm sticky top-0 z-50 border-b border-pink-100">
    <div class="container mx-auto px-4">
        <div class="flex items-center justify-between py-4">
            <!-- Logo -->
            <a href="{{ route('home') }}" class="flex items-center space-x-2 group">
                <div class="w-12 h-12 bg-gradient-to-br from-pink-400 via-rose-400 to-pink-500 rounded-2xl flex items-center justify-center shadow-lg group-hover:shadow-pink-200 transition-all duration-300">
                    <i class="fas fa-spa text-white text-xl"></i>
                </div>
                <div>
                    <span class="text-2xl font-bold bg-gradient-to-r from-pink-600 to-rose-500 bg-clip-text text-transparent font-serif">Bella Nutri</span>
                </div>
            </a>

            <!-- Search Bar -->
            <div class="hidden md:flex flex-1 max-w-xl mx-8">
                <form action="{{ route('products.index') }}" method="GET" class="w-full relative">
                    <input type="text" name="search" placeholder="Buscar produtos..." class="w-full px-5 py-3 bg-pink-50/50 border border-pink-200 rounded-full focus:outline-none focus:ring-2 focus:ring-pink-400 focus:border-transparent focus:bg-white transition-all">
                    <button type="submit" class="absolute right-4 top-1/2 transform -translate-y-1/2 text-pink-400 hover:text-pink-600 transition">
                        <i class="fas fa-search"></i>
                    </button>
                </form>
            </div>

            <!-- Actions -->
            <div class="flex items-center space-x-4">
                <a href="{{ route('products.index') }}" class="hidden sm:flex items-center text-gray-600 hover:text-pink-600 transition group">
                    <div class="w-10 h-10 bg-pink-50 rounded-full flex items-center justify-center group-hover:bg-pink-100 transition">
                        <i class="fas fa-th-large text-pink-500"></i>
                    </div>
                    <span class="ml-2 hidden lg:inline font-medium">Catálogo</span>
                </a>

                <!-- Cart -->
                <button class="relative flex items-center text-gray-600 hover:text-pink-600 transition" onclick="showCartMessage()">
                    <div class="w-10 h-10 bg-pink-50 rounded-full flex items-center justify-center hover:bg-pink-100 transition">
                        <i class="fas fa-shopping-bag text-pink-500"></i>
                    </div>
                    <span class="absolute -top-1 -right-1 w-5 h-5 bg-gradient-to-r from-rose-500 to-pink-500 text-white text-xs rounded-full flex items-center justify-center font-semibold">0</span>
                </button>

                <!-- Mobile Menu Button -->
                <button class="md:hidden text-gray-600 hover:text-pink-600 transition" onclick="toggleMobileMenu()">
                    <i class="fas fa-bars text-xl"></i>
                </button>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="hidden md:flex items-center justify-center py-3 space-x-8">
            <a href="{{ route('home') }}" class="text-gray-600 hover:text-pink-600 font-medium transition relative group {{ request()->routeIs('home') ? 'text-pink-600' : '' }}">
                Início
                <span class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-pink-500 to-rose-500 group-hover:w-full transition-all duration-300 {{ request()->routeIs('home') ? 'w-full' : '' }}"></span>
            </a>
            <a href="{{ route('products.index') }}" class="text-gray-600 hover:text-pink-600 font-medium transition relative group {{ request()->routeIs('products.*') ? 'text-pink-600' : '' }}">
                Produtos
                <span class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-pink-500 to-rose-500 group-hover:w-full transition-all duration-300 {{ request()->routeIs('products.*') ? 'w-full' : '' }}"></span>
            </a>
            <a href="{{ route('categories.index') }}" class="text-gray-600 hover:text-pink-600 font-medium transition relative group {{ request()->routeIs('categories.*') ? 'text-pink-600' : '' }}">
                Categorias
                <span class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-pink-500 to-rose-500 group-hover:w-full transition-all duration-300 {{ request()->routeIs('categories.*') ? 'w-full' : '' }}"></span>
            </a>
            <a href="{{ route('testimonials.index') }}" class="text-gray-600 hover:text-pink-600 font-medium transition relative group {{ request()->routeIs('testimonials.*') ? 'text-pink-600' : '' }}">
                Depoimentos
                <span class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-pink-500 to-rose-500 group-hover:w-full transition-all duration-300 {{ request()->routeIs('testimonials.*') ? 'w-full' : '' }}"></span>
            </a>
            <a href="#contact" class="text-gray-600 hover:text-pink-600 font-medium transition relative group">
                Contato
                <span class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-pink-500 to-rose-500 group-hover:w-full transition-all duration-300"></span>
            </a>
        </nav>
    </div>

    <!-- Mobile Menu -->
    <div id="mobileMenu" class="hidden md:hidden bg-white border-t border-pink-100">
        <div class="container mx-auto px-4 py-4">
            <form action="{{ route('products.index') }}" method="GET" class="mb-4">
                <input type="text" name="search" placeholder="Buscar produtos..." class="w-full px-4 py-3 bg-pink-50 border border-pink-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-pink-400">
            </form>
            <ul class="space-y-3">
                <li><a href="{{ route('home') }}" class="block py-3 px-4 text-gray-700 hover:bg-pink-50 hover:text-pink-600 rounded-xl transition">Início</a></li>
                <li><a href="{{ route('products.index') }}" class="block py-3 px-4 text-gray-700 hover:bg-pink-50 hover:text-pink-600 rounded-xl transition">Produtos</a></li>
                <li><a href="{{ route('categories.index') }}" class="block py-3 px-4 text-gray-700 hover:bg-pink-50 hover:text-pink-600 rounded-xl transition">Categorias</a></li>
                <li><a href="{{ route('testimonials.index') }}" class="block py-3 px-4 text-gray-700 hover:bg-pink-50 hover:text-pink-600 rounded-xl transition">Depoimentos</a></li>
                <li><a href="#contact" class="block py-3 px-4 text-gray-700 hover:bg-pink-50 hover:text-pink-600 rounded-xl transition">Contato</a></li>
            </ul>
        </div>
    </div>
</header>

<script>
function toggleMobileMenu() {
    const menu = document.getElementById('mobileMenu');
    menu.classList.toggle('hidden');
}

function showCartMessage() {
    alert('Funcionalidade de carrinho será implementada em breve!');
}
</script>
