<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pedido Confirmado - {{ config('app.name') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Header -->
    <header class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-4 py-4">
            <a href="/" class="text-2xl font-bold text-blue-600">
                {{ config('app.name') }}
            </a>
        </div>
    </header>

    <main class="max-w-3xl mx-auto px-4 py-12">
        <!-- Sucesso -->
        <div class="bg-white rounded-lg shadow-sm p-8 text-center mb-8">
            <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                </svg>
            </div>
            <h1 class="text-2xl font-bold text-gray-800 mb-2">Pedido Realizado com Sucesso!</h1>
            <p class="text-gray-600">Número do pedido: <strong>{{ $order->order_number }}</strong></p>
        </div>

        <!-- Detalhes do Pagamento -->
        @if($order->payment_method === 'pix')
            <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
                <h2 class="text-lg font-semibold mb-4 flex items-center gap-2">
                    <svg class="w-6 h-6 text-blue-600" viewBox="0 0 48 48" fill="currentColor">
                        <path d="M39.5 22h-31A2.5 2.5 0 006 24.5v19A2.5 2.5 0 008.5 46h31a2.5 2.5 0 002.5-2.5v-19a2.5 2.5 0 00-2.5-2.5z" fill="#32BCAD"/>
                    </svg>
                    Pagar via PIX
                </h2>

                @if($order->pix_qr_code)
                    <div class="text-center mb-6">
                        <p class="text-sm text-gray-600 mb-3">Escaneie o QR Code abaixo:</p>
                        <img src="{{ $order->pix_qr_code }}" alt="QR Code PIX" class="mx-auto w-48 h-48">
                    </div>
                @endif

                @if($order->pix_copy_paste)
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm text-gray-600 mb-2">Ou use o PIX Copia e Cola:</p>
                        <div class="flex gap-2">
                            <input type="text" value="{{ $order->pix_copy_paste }}" readonly
                                   class="flex-1 px-3 py-2 bg-white border rounded-lg text-sm font-mono">
                            <button onclick="copyPixCode()" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                                Copiar
                            </button>
                        </div>
                    </div>
                @endif

                <div class="mt-4 p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                    <p class="text-sm text-yellow-800">
                        <strong>Atenção:</strong> O pedido será confirmado após a confirmação do pagamento. Pode levar até 10 minutos.
                    </p>
                </div>
            </div>
        @endif

        @if($order->payment_method === 'boleto' && $order->boleto_url)
            <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
                <h2 class="text-lg font-semibold mb-4">Pagar via Boleto</h2>

                <a href="{{ $order->boleto_url }}" target="_blank"
                   class="block w-full py-3 bg-blue-600 text-white text-center rounded-lg font-semibold hover:bg-blue-700 mb-4">
                    <span class="flex items-center justify-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
                        </svg>
                        Imprimir Boleto
                    </span>
                </a>

                @if($order->boleto_barcode)
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-xs text-gray-600 mb-1">Código de barras:</p>
                        <p class="text-sm font-mono break-all">{{ $order->boleto_barcode }}</p>
                    </div>
                @endif

                <div class="mt-4 p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                    <p class="text-sm text-yellow-800">
                        <strong>Atenção:</strong> A confirmação do pagamento via boleto pode levar de 1 a 3 dias úteis.
                    </p>
                </div>
            </div>
        @endif

        @if($order->payment_method === 'credit_card')
            <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
                <h2 class="text-lg font-semibold mb-4 flex items-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    Pagamento Processado
                </h2>

                @if($order->payment_status === 'paid')
                    <div class="p-4 bg-green-50 border border-green-200 rounded-lg">
                        <p class="text-green-800">
                            <strong>Pagamento confirmado!</strong> Seu pedido será processado em breve.
                        </p>
                    </div>
                @else
                    <div class="p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                        <p class="text-yellow-800">
                            <strong>Pagamento em processamento.</strong> Você receberá uma confirmação por e-mail.
                        </p>
                    </div>
                @endif

                <div class="mt-4 text-sm">
                    <p><strong>Cartão:</strong> **** **** **** {{ substr($order->gateway_transaction_id ?? '', -4) }}</p>
                    @if($order->installments)
                        <p><strong>Parcelas:</strong> {{ $order->installments }}x de R$ {{ number_format($order->installment_value, 2, ',', '.') }}</p>
                    @endif
                </div>
            </div>
        @endif

        <!-- Resumo do Pedido -->
        <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
            <h2 class="text-lg font-semibold mb-4">Resumo do Pedido</h2>

            <div class="space-y-3 mb-4">
                @foreach($order->items as $item)
                    <div class="flex justify-between py-2 border-b">
                        <div>
                            <p class="font-medium">{{ $item->name }}</p>
                            <p class="text-sm text-gray-500">Qtd: {{ $item->quantity }}</p>
                        </div>
                        <p class="font-medium">R$ {{ number_format($item->subtotal, 2, ',', '.') }}</p>
                    </div>
                @endforeach
            </div>

            <div class="space-y-2 text-sm pt-4 border-t">
                <div class="flex justify-between">
                    <span>Subtotal</span>
                    <span>R$ {{ number_format($order->subtotal, 2, ',', '.') }}</span>
                </div>
                @if($order->discount > 0)
                    <div class="flex justify-between text-green-600">
                        <span>Desconto</span>
                        <span>- R$ {{ number_format($order->discount, 2, ',', '.') }}</span>
                    </div>
                @endif
                <div class="flex justify-between">
                    <span>Frete</span>
                    <span>{{ $order->shipping_cost == 0 ? 'GRÁTIS' : 'R$ ' . number_format($order->shipping_cost, 2, ',', '.') }}</span>
                </div>
                <div class="flex justify-between text-lg font-bold pt-2 border-t">
                    <span>Total</span>
                    <span>R$ {{ number_format($order->total, 2, ',', '.') }}</span>
                </div>
            </div>
        </div>

        <!-- Endereço de Entrega -->
        <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
            <h2 class="text-lg font-semibold mb-4">Endereço de Entrega</h2>
            <div class="text-sm">
                <p>{{ $order->customer_name }}</p>
                <p>{{ $order->shipping_address }}, {{ $order->shipping_number }}</p>
                @if($order->shipping_complement)
                    <p>{{ $order->shipping_complement }}</p>
                @endif
                <p>{{ $order->shipping_district }}</p>
                <p>{{ $order->shipping_city }} - {{ $order->shipping_state }}</p>
                <p>CEP: {{ $order->shipping_zipcode }}</p>
            </div>
        </div>

        <!-- Próximos Passos -->
        <div class="bg-blue-50 border border-blue-200 rounded-lg p-6 mb-6">
            <h2 class="text-lg font-semibold text-blue-800 mb-3">O que acontece agora?</h2>
            <ul class="space-y-2 text-sm text-blue-700">
                <li class="flex items-start gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-600 flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <span>Você receberá um e-mail de confirmação com os detalhes do pedido</span>
                </li>
                <li class="flex items-start gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-600 flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <span>Acompanhe o status do pedido pelo seu e-mail</span>
                </li>
                <li class="flex items-start gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-600 flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <span>O prazo de entrega começa a contar a partir da confirmação do pagamento</span>
                </li>
            </ul>
        </div>

        <!-- Ações -->
        <div class="flex flex-col sm:flex-row gap-4">
            <a href="/" class="flex-1 py-3 bg-blue-600 text-white text-center rounded-lg font-semibold hover:bg-blue-700">
                Continuar Comprando
            </a>
            @if(auth()->check())
                <a href="/dashboard" class="flex-1 py-3 bg-gray-200 text-gray-700 text-center rounded-lg font-semibold hover:bg-gray-300">
                    Meus Pedidos
                </a>
            @endif
        </div>
    </main>

    <script>
    function copyPixCode() {
        const code = document.querySelector('input[value="{{ $order->pix_copy_paste }}"]');
        code.select();
        document.execCommand('copy');

        const btn = event.target;
        const originalText = btn.textContent;
        btn.textContent = 'Copiado!';
        btn.classList.remove('bg-blue-600', 'hover:bg-blue-700');
        btn.classList.add('bg-green-600');

        setTimeout(() => {
            btn.textContent = originalText;
            btn.classList.remove('bg-green-600');
            btn.classList.add('bg-blue-600', 'hover:bg-blue-700');
        }, 2000);
    }
    </script>
</body>
</html>
