<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Finalizar Compra - {{ config('app.name') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://pay.pagar.me/pagarme.js"></script>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        [x-cloak] { display: none !important; }
    </style>
</head>
<body class="bg-gray-100 min-h-screen">
    <!-- Header -->
    <header class="bg-white shadow-sm sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 py-4 flex items-center justify-between">
            <a href="/" class="text-2xl font-bold text-blue-600">
                {{ config('app.name') }}
            </a>
            <div class="flex items-center gap-2 text-gray-600">
                <span class="text-sm">Passo 2 de 2:</span>
                <span class="flex items-center gap-1">
                    <span class="w-6 h-6 rounded-full bg-green-600 text-white flex items-center justify-center text-xs">✓</span>
                    Carrinho
                </span>
                <span class="text-gray-400">→</span>
                <span class="font-semibold text-blue-600">Pagamento</span>
            </div>
        </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 py-8">
        <div class="grid lg:grid-cols-3 gap-8">
            <!-- Formulário de Checkout -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Dados Pessoais -->
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <h2 class="text-lg font-semibold mb-4 flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                        </svg>
                        Dados Pessoais
                    </h2>

                    <form method="POST" action="{{ route('checkout.process') }}" id="checkoutForm">
                        @csrf
                        <div class="grid md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Nome Completo *</label>
                                <input type="text" name="name" value="{{ $user->name ?? old('name') }}" required
                                       class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">E-mail *</label>
                                <input type="email" name="email" value="{{ $user->email ?? old('email') }}" required
                                       class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Telefone *</label>
                                <input type="tel" name="phone" id="phone" value="{{ $user->phone ?? old('phone') }}" required
                                       placeholder="(11) 99999-9999"
                                       class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                       oninput="maskPhone(this)">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">CPF</label>
                                <input type="text" name="cpf" id="cpf" value="{{ old('cpf') }}"
                                       placeholder="000.000.000-00"
                                       class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                       oninput="maskCPF(this)">
                            </div>
                        </div>
                    </form>
                </div>

                <!-- Endereço de Entrega -->
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <h2 class="text-lg font-semibold mb-4 flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                        Endereço de Entrega
                    </h2>

                    <div class="space-y-4">
                        <div class="grid md:grid-cols-3 gap-4">
                            <div class="md:col-span-1">
                                <label class="block text-sm font-medium text-gray-700 mb-1">CEP *</label>
                                <div class="flex gap-2">
                                    <input type="text" name="zipcode" id="zipcode" required
                                           placeholder="00000-000"
                                           class="flex-1 px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                           oninput="maskCEP(this)" onchange="searchCEP()">
                                    <button type="button" onclick="searchCEP()" class="px-4 py-2 bg-gray-200 rounded-lg hover:bg-gray-300">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Rua/Avenida *</label>
                                <input type="text" name="address" id="address" required
                                       class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>
                        </div>

                        <div class="grid md:grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Número *</label>
                                <input type="text" name="number" id="number" required
                                       class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-1">Complemento</label>
                                <input type="text" name="complement" id="complement"
                                       class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>
                        </div>

                        <div class="grid md:grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Bairro *</label>
                                <input type="text" name="district" id="district" required
                                       class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Cidade *</label>
                                <input type="text" name="city" id="city" required
                                       class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Estado *</label>
                                <select name="state" id="state" required
                                        class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                    <option value="">Selecione</option>
                                    <option value="AC">Acre</option>
                                    <option value="AL">Alagoas</option>
                                    <option value="AP">Amapá</option>
                                    <option value="AM">Amazonas</option>
                                    <option value="BA">Bahia</option>
                                    <option value="CE">Ceará</option>
                                    <option value="DF">Distrito Federal</option>
                                    <option value="ES">Espírito Santo</option>
                                    <option value="GO">Goiás</option>
                                    <option value="MA">Maranhão</option>
                                    <option value="MT">Mato Grosso</option>
                                    <option value="MS">Mato Grosso do Sul</option>
                                    <option value="MG">Minas Gerais</option>
                                    <option value="PA">Pará</option>
                                    <option value="PB">Paraíba</option>
                                    <option value="PR">Paraná</option>
                                    <option value="PE">Pernambuco</option>
                                    <option value="PI">Piauí</option>
                                    <option value="RJ">Rio de Janeiro</option>
                                    <option value="RN">Rio Grande do Norte</option>
                                    <option value="RS">Rio Grande do Sul</option>
                                    <option value="RO">Rondônia</option>
                                    <option value="RR">Roraima</option>
                                    <option value="SC">Santa Catarina</option>
                                    <option value="SP">São Paulo</option>
                                    <option value="SE">Sergipe</option>
                                    <option value="TO">Tocantins</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Método de Pagamento -->
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <h2 class="text-lg font-semibold mb-4 flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                        </svg>
                        Forma de Pagamento
                    </h2>

                    <div class="space-y-4">
                        <!-- PIX -->
                        @if($asaasPixEnabled)
                        <label class="flex items-start p-4 border rounded-lg cursor-pointer hover:border-blue-500 transition payment-option {{ $pixDiscount > 0 ? 'border-green-500 bg-green-50' : '' }}">
                            <input type="radio" name="payment_method" value="pix" class="mt-1" required
                                   onchange="togglePaymentMethod('pix')">
                            <div class="ml-3">
                                <div class="flex items-center gap-2">
                                    <span class="font-semibold">PIX</span>
                                    @if($pixDiscount > 0)
                                        <span class="text-xs bg-green-600 text-white px-2 py-0.5 rounded-full">{{ $pixDiscount }}% OFF</span>
                                    @endif
                                </div>
                                <p class="text-sm text-gray-600">Pagamento instantâneo via QR Code ou Copia e Cola</p>
                                @if($pixDiscount > 0)
                                    <p class="text-sm text-green-600 font-medium">
                                        Total: R$ {{ number_format($cart['pix_total'], 2, ',', '.') }}
                                    </p>
                                @endif
                            </div>
                            <div class="ml-auto">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-blue-600" viewBox="0 0 48 48" fill="currentColor">
                                    <path d="M39.5 22h-31A2.5 2.5 0 006 24.5v19A2.5 2.5 0 008.5 46h31a2.5 2.5 0 002.5-2.5v-19a2.5 2.5 0 00-2.5-2.5z" fill="#32BCAD"/>
                                    <path d="M22 28.5c0-.83-.67-1.5-1.5-1.5h-7c-.83 0-1.5.67-1.5 1.5v11c0 .83.67 1.5 1.5 1.5h7c.83 0 1.5-.67 1.5-1.5v-11z" fill="#fff"/>
                                    <path d="M42 2H6C3.79 2 2 3.79 2 6v36c0 2.21 1.79 4 4 4h36c2.21 0 4-1.79 4-4V6c0-2.21-1.79-4-4-4z" fill="none"/>
                                </svg>
                            </div>
                        </label>
                        @endif

                        <!-- Cartão de Crédito -->
                        @if($asaasCreditCardEnabled)
                        <label class="flex items-start p-4 border rounded-lg cursor-pointer hover:border-blue-500 transition payment-option">
                            <input type="radio" name="payment_method" value="credit_card" class="mt-1" required
                                   onchange="togglePaymentMethod('credit_card')">
                            <div class="ml-3 flex-1">
                                <span class="font-semibold">Cartão de Crédito</span>
                                <p class="text-sm text-gray-600">Parcele em até {{ $maxInstallments }}x</p>

                                <!-- Campos do Cartão -->
                                <div id="creditCardFields" class="mt-4 space-y-4 hidden">
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-1">Número do Cartão *</label>
                                        <input type="text" name="card_number" id="card_number" placeholder="0000 0000 0000 0000"
                                               class="w-full px-4 py-2 border rounded-lg" oninput="maskCardNumber(this)">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-1">Nome no Cartão *</label>
                                        <input type="text" name="card_holder" placeholder="NOME COMO ESTÁ NO CARTÃO"
                                               class="w-full px-4 py-2 border rounded-lg uppercase">
                                    </div>
                                    <div class="grid grid-cols-3 gap-4">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Mês *</label>
                                            <select name="card_expiration_month" class="w-full px-4 py-2 border rounded-lg">
                                                @for($i = 1; $i <= 12; $i++)
                                                    <option value="{{ $i }}">{{ str_pad($i, 2, '0', STR_PAD_LEFT) }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Ano *</label>
                                            <select name="card_expiration_year" class="w-full px-4 py-2 border rounded-lg">
                                                @for($i = date('Y'); $i <= date('Y') + 10; $i++)
                                                    <option value="{{ $i }}">{{ $i }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700 mb-1">CVV *</label>
                                            <input type="text" name="card_cvv" placeholder="123" maxlength="4"
                                                   class="w-full px-4 py-2 border rounded-lg">
                                        </div>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Parcelas *</label>
                                        <select name="installments" id="installments" class="w-full px-4 py-2 border rounded-lg">
                                            @foreach($availableInstallments as $count => $value)
                                                <option value="{{ $count }}">{{ $count }}x de R$ {{ $value }} {{ $count === 1 ? '(sem juros)' : '' }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="ml-auto flex gap-1">
                                <svg class="h-6 w-6" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 15h-2v-6h2v6zm0-8h-2V7h2v2z" fill="#666"/>
                                </svg>
                            </div>
                        </label>
                        @endif

                        <!-- Boleto -->
                        @if($asaasBoletoEnabled)
                        <label class="flex items-start p-4 border rounded-lg cursor-pointer hover:border-blue-500 transition payment-option">
                            <input type="radio" name="payment_method" value="boleto" class="mt-1" required
                                   onchange="togglePaymentMethod('boleto')">
                            <div class="ml-3">
                                <span class="font-semibold">Boleto Bancário</span>
                                <p class="text-sm text-gray-600">Vencimento em 3 dias úteis</p>
                                <p class="text-xs text-gray-500 mt-1">Confirmação em 1 a 3 dias úteis</p>
                            </div>
                            <div class="ml-auto">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                </svg>
                            </div>
                        </label>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Resumo do Pedido -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-lg shadow-sm p-6 sticky top-24">
                    <h2 class="text-lg font-semibold mb-4">Resumo do Pedido</h2>

                    <!-- Itens -->
                    <div class="space-y-3 mb-4 max-h-64 overflow-y-auto">
                        @foreach($cart['items'] as $item)
                            <div class="flex gap-3">
                                @if($item['image'])
                                    <img src="{{ Storage::url($item['image']) }}" alt="{{ $item['name'] }}" class="w-12 h-12 object-cover rounded">
                                @else
                                    <div class="w-12 h-12 bg-gray-200 rounded"></div>
                                @endif
                                <div class="flex-1">
                                    <p class="text-sm font-medium">{{ $item['name'] }}</p>
                                    <p class="text-xs text-gray-500">Qtd: {{ $item['quantity'] }}</p>
                                </div>
                                <p class="text-sm font-medium">
                                    R$ {{ number_format(($item['discount_price'] ?? $item['price']) * $item['quantity'], 2, ',', '.') }}
                                </p>
                            </div>
                        @endforeach
                    </div>

                    <!-- Totais -->
                    <div class="border-t pt-4 space-y-2 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Subtotal</span>
                            <span>R$ {{ number_format($cart['subtotal'], 2, ',', '.') }}</span>
                        </div>

                        @if($cart['discount'] > 0)
                            <div class="flex justify-between text-green-600">
                                <span>Desconto</span>
                                <span>- R$ {{ number_format($cart['discount'], 2, ',', '.') }}</span>
                            </div>
                        @endif

                        <div class="flex justify-between">
                            <span class="text-gray-600">Frete</span>
                            <span>{{ $cart['free_shipping'] ? 'GRÁTIS' : 'R$ ' . number_format($cart['shipping_cost'], 2, ',', '.') }}</span>
                        </div>

                        <div class="border-t pt-2 mt-2">
                            <div class="flex justify-between text-lg font-bold">
                                <span>Total</span>
                                <span id="totalValue">R$ {{ number_format($cart['total'], 2, ',', '.') }}</span>
                            </div>
                        </div>

                        @if($pixDiscount > 0)
                            <div class="bg-green-50 border border-green-200 rounded-lg p-3">
                                <p class="text-xs text-green-700">
                                    <strong>Economize R$ {{ number_format($cart['total'] - $cart['pix_total'], 2, ',', '.') }}</strong> no PIX
                                </p>
                            </div>
                        @endif
                    </div>

                    <!-- Botão Finalizar -->
                    <button type="submit" form="checkoutForm" id="submitBtn"
                            class="w-full mt-6 py-3 bg-green-600 text-white rounded-lg font-semibold hover:bg-green-700 transition flex items-center justify-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        Finalizar Pedido
                    </button>

                    <div class="flex items-center justify-center gap-2 mt-4 text-xs text-gray-500">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                        </svg>
                        Ambiente seguro
                    </div>
                </div>
            </div>
        </div>
    </main>

    <script>
    // Máscaras de input
    function maskPhone(input) {
        let value = input.value.replace(/\D/g, '');
        if (value.length > 11) value = value.slice(0, 11);
        if (value.length > 6) {
            value = `(${value.slice(0,2)}) ${value.slice(2,7)}-${value.slice(7)}`;
        } else if (value.length > 2) {
            value = `(${value.slice(0,2)}) ${value.slice(2)}`;
        } else if (value.length > 0) {
            value = `(${value}`;
        }
        input.value = value;
    }

    function maskCPF(input) {
        let value = input.value.replace(/\D/g, '');
        if (value.length > 11) value = value.slice(0, 11);
        if (value.length > 9) {
            value = `${value.slice(0,3)}.${value.slice(3,6)}.${value.slice(6,9)}-${value.slice(9)}`;
        } else if (value.length > 6) {
            value = `${value.slice(0,3)}.${value.slice(3,6)}.${value.slice(6)}`;
        } else if (value.length > 3) {
            value = `${value.slice(0,3)}.${value.slice(3)}`;
        }
        input.value = value;
    }

    function maskCEP(input) {
        let value = input.value.replace(/\D/g, '');
        if (value.length > 8) value = value.slice(0, 8);
        if (value.length > 5) {
            value = `${value.slice(0,5)}-${value.slice(5)}`;
        }
        input.value = value;
    }

    function maskCardNumber(input) {
        let value = input.value.replace(/\D/g, '');
        if (value.length > 16) value = value.slice(0, 16);
        value = value.match(/.{1,4}/g)?.join(' ') || value;
        input.value = value;
    }

    // Buscar CEP
    async function searchCEP() {
        const cep = document.getElementById('zipcode').value.replace(/\D/g, '');
        if (cep.length !== 8) return;

        try {
            const response = await fetch(`/checkout/cep/${cep}`);
            const data = await response.json();

            if (!data.error) {
                document.getElementById('address').value = data.logradouro || '';
                document.getElementById('district').value = data.bairro || '';
                document.getElementById('city').value = data.localidade || '';
                document.getElementById('state').value = data.uf || '';
                document.getElementById('number').focus();
            }
        } catch (error) {
            console.error('Erro ao buscar CEP:', error);
        }
    }

    // Toggle método de pagamento
    function togglePaymentMethod(method) {
        const creditFields = document.getElementById('creditCardFields');
        const totalValue = document.getElementById('totalValue');
        const total = {{ $cart['total'] }};
        const pixTotal = {{ $cart['pix_total'] ?? $cart['total'] }};

        if (method === 'credit_card') {
            creditFields.classList.remove('hidden');
        } else {
            creditFields.classList.add('hidden');
        }

        if (method === 'pix') {
            totalValue.textContent = 'R$ ' + pixTotal.toFixed(2).replace('.', ',');
        } else {
            totalValue.textContent = 'R$ ' + total.toFixed(2).replace('.', ',');
        }
    }
    </script>
</body>
</html>
