@extends('layouts.app')

@section('title', "$category->name - Suplementos Store")

@section('content')
<!-- Breadcrumb -->
<nav class="bg-gray-100 py-3">
    <div class="container mx-auto px-4">
        <ol class="flex items-center space-x-2 text-sm">
            <li><a href="{{ route('home') }}" class="text-gray-600 hover:text-primary-600"><i class="fas fa-home"></i></a></li>
            <li class="text-gray-400">/</li>
            <li><a href="{{ route('categories.index') }}" class="text-gray-600 hover:text-primary-600">Categorias</a></li>
            @if($category->parent)
                <li class="text-gray-400">/</li>
                <li><a href="{{ route('categories.show', $category->parent->slug) }}" class="text-gray-600 hover:text-primary-600">{{ $category->parent->name }}</a></li>
            @endif
            <li class="text-gray-400">/</li>
            <li class="text-gray-800 font-medium">{{ $category->name }}</li>
        </ol>
    </div>
</nav>

<!-- Category Header -->
<section class="bg-gradient-to-r from-primary-700 to-primary-900 text-white py-16">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto text-center">
            <h1 class="text-3xl md:text-4xl font-bold mb-4">{{ $category->name }}</h1>
            @if($category->description)
                <p class="text-primary-100 text-lg">{{ $category->description }}</p>
            @endif
            <p class="text-primary-200 mt-4">{{ $products->total() }} produtos disponíveis</p>
        </div>
    </div>
</section>

<!-- Subcategories -->
@if($childCategories->count() > 0)
<section class="py-8 bg-gray-50 border-b">
    <div class="container mx-auto px-4">
        <div class="flex flex-wrap items-center gap-3">
            <span class="text-gray-700 font-medium">Refinar por:</span>
            @foreach($childCategories as $child)
                <a href="{{ route('categories.show', $child->slug) }}"
                   class="px-4 py-2 bg-white border border-gray-200 rounded-full text-gray-700 hover:bg-primary-600 hover:text-white hover:border-primary-600 transition">
                    {{ $child->name }}
                    <span class="text-xs text-gray-400">({{ $child->products_count }})</span>
                </a>
            @endforeach
        </div>
    </div>
</section>
@endif

<!-- Products Grid -->
<section class="py-12">
    <div class="container mx-auto px-4">
        @if($products->count() > 0)
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @foreach($products as $product)
                    @include('partials.product-card', ['product' => $product])
                @endforeach
            </div>

            <!-- Pagination -->
            @if($products->hasPages())
                <div class="mt-12">
                    {{ $products->appends(request()->except('page'))->links() }}
                </div>
            @endif
        @else
            <div class="bg-white rounded-xl shadow-md p-12 text-center">
                <i class="fas fa-box-open text-gray-300 text-6xl mb-4"></i>
                <h3 class="text-xl font-semibold text-gray-800 mb-2">Nenhum produto encontrado</h3>
                <p class="text-gray-600 mb-4">Esta categoria ainda não possui produtos.</p>
                <a href="{{ route('categories.index') }}" class="inline-block px-6 py-2 bg-primary-600 text-white rounded-lg hover:bg-primary-700 transition">
                    Ver Outras Categorias
                </a>
            </div>
        @endif
    </div>
</section>
@endsection
