@extends('layouts.app')

@section('title', 'Categorias - Suplementos Store')

@section('content')
<!-- Page Header -->
<section class="bg-gradient-to-r from-primary-700 to-primary-900 text-white py-12">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto text-center">
            <h1 class="text-3xl md:text-4xl font-bold mb-4">Nossas Categorias</h1>
            <p class="text-primary-100 text-lg">
                Encontre o suplemento ideal para seus objetivos
            </p>
        </div>
    </div>
</section>

<!-- Categories Grid -->
<section class="py-16">
    <div class="container mx-auto px-4">
        @if($categories->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                @foreach($categories as $category)
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2">
                        <!-- Category Header -->
                        <div class="bg-gradient-to-r from-primary-600 to-primary-700 p-6 text-white">
                            <div class="flex items-center justify-between">
                                <div>
                                    <h2 class="text-2xl font-bold">{{ $category->name }}</h2>
                                    @if($category->description)
                                        <p class="text-primary-100 text-sm mt-1">{{ $category->description }}</p>
                                    @endif
                                </div>
                                <div class="w-16 h-16 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                                    <i class="fas fa-dumbbell text-3xl"></i>
                                </div>
                            </div>
                        </div>

                        <!-- Products Preview -->
                        @if($category->products->count() > 0)
                            <div class="p-6">
                                <div class="flex items-center justify-between mb-4">
                                    <span class="text-gray-600">{{ $category->products_count }} produtos</span>
                                    <a href="{{ route('categories.show', $category->slug) }}" class="text-primary-600 hover:text-primary-700 font-medium">
                                        Ver todos <i class="fas fa-arrow-right ml-1"></i>
                                    </a>
                                </div>
                                <div class="grid grid-cols-4 gap-2">
                                    @foreach($category->products->take(4) as $product)
                                        <a href="{{ route('products.show', $product->slug) }}" class="aspect-square rounded-lg overflow-hidden">
                                            @if($product->images->first())
                                                <img src="{{ $product->images->first()->url }}" alt="{{ $product->name }}"
                                                     class="w-full h-full object-cover hover:scale-110 transition-transform duration-300">
                                            @else
                                                <div class="w-full h-full bg-gray-200 flex items-center justify-center">
                                                    <i class="fas fa-image text-gray-400"></i>
                                                </div>
                                            @endif
                                        </a>
                                    @endforeach
                                </div>
                            </div>
                        @else
                            <div class="p-6 text-center">
                                <p class="text-gray-500">Nenhum produto disponível</p>
                            </div>
                        @endif

                        <!-- Subcategories -->
                        @if($category->children->count() > 0)
                            <div class="border-t p-4 bg-gray-50">
                                <p class="text-sm text-gray-600 mb-2">Subcategorias:</p>
                                <div class="flex flex-wrap gap-2">
                                    @foreach($category->children->take(5) as $child)
                                        <a href="{{ route('categories.show', $child->slug) }}"
                                           class="text-xs bg-white px-3 py-1 rounded-full text-gray-700 hover:bg-primary-100 hover:text-primary-700 transition">
                                            {{ $child->name }}
                                        </a>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-12">
                <i class="fas fa-folder-open text-gray-300 text-6xl mb-4"></i>
                <h3 class="text-xl font-semibold text-gray-800 mb-2">Nenhuma categoria disponível</h3>
                <p class="text-gray-600">Em breve teremos novas categorias disponíveis.</p>
            </div>
        @endif
    </div>
</section>
@endsection
