<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Meu Carrinho - {{ config('app.name') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <meta name="csrf-token" content="{{ csrf_token() }}">
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Header -->
    <header class="bg-white shadow-sm sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 py-4 flex items-center justify-between">
            <a href="/" class="text-2xl font-bold text-blue-600">
                {{ config('app.name') }}
            </a>
            <a href="/" class="text-gray-600 hover:text-gray-800 flex items-center gap-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
                Continuar Comprando
            </a>
        </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 py-8">
        <h1 class="text-3xl font-bold text-gray-800 mb-8">Meu Carrinho</h1>

        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
                {{ session('success') }}
            </div>
        @endif

        @if(session('error'))
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                {{ session('error') }}
            </div>
        @endif

        @if(empty($cart['items']))
            <!-- Carrinho Vazio -->
            <div class="bg-white rounded-lg shadow-sm p-12 text-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-24 w-24 mx-auto text-gray-300 mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                </svg>
                <h2 class="text-xl font-semibold text-gray-700 mb-2">Seu carrinho está vazio</h2>
                <p class="text-gray-500 mb-6">Adicione produtos para continuar comprando</p>
                <a href="/" class="inline-block px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">
                    Ver Produtos
                </a>
            </div>
        @else
            <div class="grid lg:grid-cols-3 gap-8">
                <!-- Lista de Produtos -->
                <div class="lg:col-span-2 space-y-4">
                    @foreach($cart['items'] as $index => $item)
                        <div class="bg-white rounded-lg shadow-sm p-4 flex gap-4">
                            <!-- Imagem -->
                            <div class="flex-shrink-0">
                                @if($item['image'])
                                    <img src="{{ Storage::url($item['image']) }}" alt="{{ $item['name'] }}"
                                         class="w-24 h-24 object-cover rounded-lg">
                                @else
                                    <div class="w-24 h-24 bg-gray-200 rounded-lg flex items-center justify-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                        </svg>
                                    </div>
                                @endif
                            </div>

                            <!-- Info -->
                            <div class="flex-1">
                                <div class="flex justify-between start">
                                    <div>
                                        <span class="text-xs font-medium text-blue-600 uppercase">
                                            {{ $item['type'] === 'combo' ? 'Combo' : 'Produto' }}
                                        </span>
                                        <h3 class="font-semibold text-gray-800">{{ $item['name'] }}</h3>

                                        @if($item['variant'])
                                            <div class="text-sm text-gray-500 mt-1">
                                                @foreach($item['variant'] as $variantName => $variantValue)
                                                    <span class="inline-block bg-gray-100 px-2 py-0.5 rounded text-xs mr-1">
                                                        {{ $variantValue }}
                                                    </span>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                    <form action="{{ route('cart.remove') }}" method="POST" class="text-right">
                                        @csrf
                                        <input type="hidden" name="index" value="{{ $index }}">
                                        <button type="submit" class="text-red-500 hover:text-red-700 text-sm">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                            </svg>
                                        </button>
                                    </form>
                                </div>

                                <div class="flex items-center justify-between mt-4">
                                    <!-- Quantidade -->
                                    <form action="{{ route('cart.update') }}" method="POST" class="flex items-center gap-3">
                                        @csrf
                                        <input type="hidden" name="index" value="{{ $index }}">

                                        <div class="flex items-center border rounded-lg">
                                            <button type="button" onclick="changeQty({{ $index }}, -1)" class="px-3 py-1 hover:bg-gray-100">-</button>
                                            <input type="number" name="quantity" value="{{ $item['quantity'] }}" min="1"
                                                   class="w-16 text-center border-0 focus:ring-0" id="qty-{{ $index }}">
                                            <button type="button" onclick="changeQty({{ $index }}, 1)" class="px-3 py-1 hover:bg-gray-100">+</button>
                                        </div>
                                        <button type="submit" class="text-blue-600 hover:text-blue-700 text-sm font-medium">
                                            Atualizar
                                        </button>
                                    </form>

                                    <!-- Preço -->
                                    <div class="text-right">
                                        @if($item['discount_price'] && $item['discount_price'] < $item['price'])
                                            <p class="text-sm text-gray-400 line-through">R$ {{ number_format($item['price'], 2, ',', '.') }}</p>
                                            <p class="text-lg font-bold text-gray-800">R$ {{ number_format($item['discount_price'], 2, ',', '.') }}</p>
                                        @else
                                            <p class="text-lg font-bold text-gray-800">R$ {{ number_format($item['price'], 2, ',', '.') }}</p>
                                        @endif

                                        @if($item['pix_price'] && $item['pix_price'] < ($item['discount_price'] ?? $item['price']))
                                            <p class="text-xs text-green-600 font-medium">
                                                PIX: R$ {{ number_format($item['pix_price'], 2, ',', '.') }}
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Resumo do Pedido -->
                <div class="lg:col-span-1">
                    <div class="bg-white rounded-lg shadow-sm p-6 sticky top-24">
                        <h2 class="text-lg font-semibold mb-4">Resumo do Pedido</h2>

                        <!-- Cupom -->
                        @if($cart['coupon'])
                            <div class="bg-green-50 border border-green-200 rounded-lg p-3 mb-4">
                                <div class="flex justify-between items-center">
                                    <div>
                                        <p class="text-sm font-medium text-green-800">Cupom Aplicado</p>
                                        <p class="text-xs text-green-600">{{ $cart['coupon']['code'] }}</p>
                                    </div>
                                    <form action="{{ route('cart.remove-coupon') }}" method="POST">
                                        @csrf
                                        <button type="submit" class="text-red-500 hover:text-red-700 text-sm">Remover</button>
                                    </form>
                                </div>
                            </div>
                        @else
                            <form action="{{ route('cart.apply-coupon') }}" method="POST" class="mb-4">
                                @csrf
                                <div class="flex gap-2">
                                    <input type="text" name="code" placeholder="Cupom de desconto"
                                           class="flex-1 px-3 py-2 border rounded-lg text-sm uppercase">
                                    <button type="submit" class="px-4 py-2 bg-gray-800 text-white rounded-lg text-sm hover:bg-gray-900">
                                        Aplicar
                                    </button>
                                </div>
                            </form>
                        @endif

                        <!-- Totais -->
                        <div class="space-y-3 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Subtotal</span>
                                <span class="font-medium">R$ {{ number_format($cart['subtotal'], 2, ',', '.') }}</span>
                            </div>

                            @if($cart['discount'] > 0)
                                <div class="flex justify-between text-green-600">
                                    <span>Desconto</span>
                                    <span class="font-medium">- R$ {{ number_format($cart['discount'], 2, ',', '.') }}</span>
                                </div>
                            @endif

                            @if($cart['free_shipping'])
                                <div class="flex justify-between text-green-600">
                                    <span>Frete</span>
                                    <span class="font-medium">GRÁTIS</span>
                                </div>
                            @elseif($cart['shipping_cost'] > 0)
                                <div class="flex justify-between">
                                    <span class="text-gray-600">Frete</span>
                                    <span class="font-medium">R$ {{ number_format($cart['shipping_cost'], 2, ',', '.') }}</span>
                                </div>
                            @else
                                <div class="flex justify-between text-green-600">
                                    <span>Frete</span>
                                    <span class="font-medium">GRÁTIS</span>
                                </div>
                            @endif

                            <div class="border-t pt-3">
                                <div class="flex justify-between">
                                    <span class="font-semibold">Total</span>
                                    <span class="font-bold text-lg">R$ {{ number_format($cart['total'], 2, ',', '.') }}</span>
                                </div>
                            </div>

                            @if($cart['pix_total'] && $cart['pix_total'] < $cart['total'])
                                <div class="bg-green-50 border border-green-200 rounded-lg p-3">
                                    <div class="flex justify-between items-center">
                                        <div>
                                            <p class="text-sm font-medium text-green-800">No PIX</p>
                                            <p class="text-xs text-green-600">à vista</p>
                                        </div>
                                        <span class="font-bold text-green-700">
                                            R$ {{ number_format($cart['pix_total'], 2, ',', '.') }}
                                        </span>
                                    </div>
                                </div>
                            @endif
                        </div>

                        <!-- Progresso Frete Grátis -->
                        @if(!$cart['free_shipping'] && isset($cart['subtotal']) && $cart['subtotal'] < ($freeShippingThreshold ?? 9999))
                            @php
                                $remaining = ($freeShippingThreshold ?? 0) - $cart['subtotal'];
                                $percentage = min(100, ($cart['subtotal'] / ($freeShippingThreshold ?? 1)) * 100);
                            @endphp
                            @if($freeShippingThreshold ?? 0)
                                <div class="mt-4">
                                    <div class="flex justify-between text-xs text-gray-600 mb-1">
                                        <span>Faltam R$ {{ number_format($remaining, 2, ',', '.') }} para frete grátis</span>
                                        <span>{{ number_format($percentage, 0) }}%</span>
                                    </div>
                                    <div class="w-full bg-gray-200 rounded-full h-2">
                                        <div class="bg-blue-600 h-2 rounded-full transition-all" style="width: {{ $percentage }}%"></div>
                                    </div>
                                </div>
                            @endif
                        @endif

                        <!-- Botão Checkout -->
                        <form action="{{ route('checkout.index') }}" method="GET" class="mt-6">
                            <button type="submit" class="w-full py-3 bg-green-600 text-white rounded-lg font-semibold hover:bg-green-700 transition flex items-center justify-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                </svg>
                                Finalizar Compra
                            </button>
                        </form>

                        <p class="text-xs text-gray-500 text-center mt-3">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 inline mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                            </svg>
                            Pagamento seguro com Asaas
                        </p>
                    </div>
                </div>
            </div>
        @endif
    </main>

    <script>
    function changeQty(index, delta) {
        const input = document.getElementById('qty-' + index);
        let newValue = parseInt(input.value) + delta;
        if (newValue >= 1) {
            input.value = newValue;
        }
    }
    </script>
</body>
</html>
