@extends('admin.layouts.app')

@section('title', $product->name)

@section('header', $product->name)

@section('content')
<div class="mb-4">
    <a href="{{ route('admin.products.index') }}" class="text-blue-600 hover:text-blue-800">
        &larr; Voltar para Produtos
    </a>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Informações do Produto -->
    <div class="lg:col-span-2 space-y-6">
        <!-- Imagens -->
        @if($product->images->count() > 0)
            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold mb-4">Imagens</h3>
                <div class="grid grid-cols-3 gap-4">
                    @foreach($product->images as $image)
                        <div class="relative @if($image->is_main) ring-2 ring-blue-500 @endif rounded">
                            <img src="{{ asset('storage/' . $image->image_path) }}"
                                 alt="{{ $product->name }}" class="w-full h-40 object-cover rounded">
                            @if($image->is_main)
                                <span class="absolute top-2 left-2 px-2 py-1 bg-blue-600 text-white text-xs rounded">Principal</span>
                            @endif
                        </div>
                    @endforeach
                </div>
            </div>
        @endif

        <!-- Descrição -->
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="text-lg font-semibold mb-4">Descrição</h3>
            @if($product->short_description)
                <p class="text-gray-700 mb-4">{{ $product->short_description }}</p>
            @endif
            <div class="prose max-w-none">
                {!! nl2br(e($product->description)) !!}
            </div>
        </div>

        <!-- Detalhes -->
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="text-lg font-semibold mb-4">Detalhes do Produto</h3>
            <dl class="grid grid-cols-2 gap-4">
                @if($product->brand)
                    <div>
                        <dt class="text-sm text-gray-500">Marca</dt>
                        <dd class="font-medium">{{ $product->brand }}</dd>
                    </div>
                @endif
                @if($product->weight)
                    <div>
                        <dt class="text-sm text-gray-500">Peso</dt>
                        <dd class="font-medium">{{ $product->weight }}g</dd>
                    </div>
                @endif
                @if($product->flavor)
                    <div>
                        <dt class="text-sm text-gray-500">Sabor</dt>
                        <dd class="font-medium">{{ $product->flavor }}</dd>
                    </div>
                @endif
                @if($product->servings)
                    <div>
                        <dt class="text-sm text-gray-500">Porções</dt>
                        <dd class="font-medium">{{ $product->servings }}</dd>
                    </div>
                @endif
            </dl>
            @if($product->ingredients)
                <div class="mt-4">
                    <dt class="text-sm text-gray-500">Ingredientes</dt>
                    <dd class="mt-1">{{ $product->ingredients }}</dd>
                </div>
            @endif
            @if($product->usage_instructions)
                <div class="mt-4">
                    <dt class="text-sm text-gray-500">Modo de Uso</dt>
                    <dd class="mt-1">{{ $product->usage_instructions }}</dd>
                </div>
            @endif
        </div>

        <!-- Variantes -->
        @if($product->productVariants->count() > 0)
            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold mb-4">Variantes Disponíveis</h3>
                <div class="space-y-3">
                    @foreach($product->variants_by_type as $type => $variantData)
                        <div class="border rounded-lg p-4">
                            <h4 class="font-medium mb-2">{{ $variantData['name'] }}</h4>
                            <div class="grid grid-cols-2 gap-2">
                                @foreach($variantData['values'] as $value)
                                    <div class="flex justify-between items-center bg-gray-50 rounded px-3 py-2">
                                        <span>{{ $value['value'] }}</span>
                                        <span class="text-sm text-gray-500">
                                            @if($value['price_adjustment'] != 0)
                                                {{ $value['price_adjustment'] > 0 ? '+' : '' }}R$ {{ number_format($value['price_adjustment'], 2, ',', '.') }}
                                            @endif
                                            ({{ $value['stock'] }} un.)
                                        </span>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif

        <!-- Vídeo -->
        @if($product->video_url)
            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold mb-4">Vídeo</h3>
                <div class="aspect-video bg-gray-100 rounded flex items-center justify-center">
                    <a href="{{ $product->video_url }}" target="_blank" class="text-blue-600 hover:text-blue-800">
                        <svg class="w-16 h-16" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM9.555 7.168A1 1 0 008 8v4a1 1 0 001.555.832l3-2a1 1 0 000-1.664l-3-2z" clip-rule="evenodd"></path>
                        </svg>
                    </a>
                </div>
            </div>
        @endif
    </div>

    <!-- Sidebar -->
    <div class="space-y-6">
        <!-- Ações -->
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="text-lg font-semibold mb-4">Ações</h3>
            <div class="space-y-3">
                <a href="{{ route('admin.products.edit', $product) }}"
                   class="block w-full px-4 py-2 bg-blue-600 text-white text-center rounded-lg hover:bg-blue-700 transition">
                    Editar Produto
                </a>
                <form method="POST" action="{{ route('admin.products.destroy', $product) }}"
                      onsubmit="return confirm('Deseja realmente deletar este produto?');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="w-full px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 transition">
                        Deletar Produto
                    </button>
                </form>
            </div>
        </div>

        <!-- Preço e Estoque -->
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="text-lg font-semibold mb-4">Preço e Estoque</h3>
            <dl class="space-y-3">
                <div class="flex justify-between">
                    <span class="text-gray-500">Preço</span>
                    <span class="font-medium">R$ {{ number_format($product->price, 2, ',', '.') }}</span>
                </div>
                @if($product->discount_price)
                    <div class="flex justify-between">
                        <span class="text-gray-500">Preço com Desconto</span>
                        <span class="font-medium text-green-600">R$ {{ number_format($product->discount_price, 2, ',', '.') }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Desconto</span>
                        <span class="font-medium text-green-600">{{ $product->discount_percentage }}%</span>
                    </div>
                @endif
                <div class="flex justify-between">
                    <span class="text-gray-500">Estoque</span>
                    <span class="font-medium @if($product->stock > 10) text-green-600 @elseif($product->stock > 0) text-yellow-600 @else text-red-600 @endif">
                        {{ $product->stock ?? 0 }} unidades
                    </span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Status</span>
                    @if($product->is_active)
                        <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">Ativo</span>
                    @else
                        <span class="px-2 py-1 text-xs rounded-full bg-gray-100 text-gray-800">Inativo</span>
                    @endif
                </div>
                @if($product->is_featured)
                    <div class="flex justify-between">
                        <span class="text-gray-500">Destaque</span>
                        <span class="px-2 py-1 text-xs rounded-full bg-yellow-100 text-yellow-800">Sim</span>
                    </div>
                @endif
            </dl>
        </div>

        <!-- Informações de Sistema -->
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="text-lg font-semibold mb-4">Informações</h3>
            <dl class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500">SKU</span>
                    <span class="font-mono">{{ $product->sku ?? '-' }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Slug</span>
                    <span class="font-mono text-xs">{{ $product->slug }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Categoria</span>
                    <span>{{ $product->category->name ?? '-' }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">ID</span>
                    <span class="font-mono">#{{ $product->id }}</span>
                </div>
            </dl>
        </div>
    </div>
</div>
@endsection
