@extends('admin.layouts.app')

@section('title', 'Importar Produtos')

@section('header', 'Importar Produtos')

@section('content')
<div class="max-w-4xl mx-auto">
    <!-- Instructions Card -->
    <div class="bg-gradient-to-br from-pink-50 to-rose-50 rounded-2xl p-6 mb-8 border border-pink-100">
        <div class="flex items-start space-x-4">
            <div class="w-12 h-12 bg-gradient-to-br from-pink-500 to-rose-500 rounded-xl flex items-center justify-center flex-shrink-0">
                <i class="fas fa-info text-white text-xl"></i>
            </div>
            <div>
                <h3 class="text-lg font-bold text-gray-800 mb-2">Como importar produtos via CSV</h3>
                <ol class="text-sm text-gray-700 space-y-2">
                    <li>1. Baixe o template abaixo para ver o formato esperado</li>
                    <li>2. Preencha o arquivo CSV com os dados dos produtos</li>
                    <li>3. Selecione o arquivo e clique em "Importar"</li>
                    <li>4. Os produtos serão criados ou atualizados automaticamente</li>
                </ol>
            </div>
        </div>
    </div>

    <!-- Download Template -->
    <div class="bg-white rounded-2xl shadow-sm p-6 mb-8 border border-gray-100">
        <div class="flex items-center justify-between">
            <div class="flex items-center space-x-4">
                <div class="w-12 h-12 bg-green-100 rounded-xl flex items-center justify-center">
                    <i class="fas fa-file-csv text-green-600 text-xl"></i>
                </div>
                <div>
                    <h4 class="font-semibold text-gray-800">Template de Importação</h4>
                    <p class="text-sm text-gray-500">Baixe o arquivo modelo com o formato correto</p>
                </div>
            </div>
            <a href="{{ route('admin.products.import.template') }}"
               class="px-6 py-3 bg-gradient-to-r from-green-500 to-emerald-500 text-white font-semibold rounded-xl hover:from-green-600 hover:to-emerald-600 transition flex items-center space-x-2">
                <i class="fas fa-download"></i>
                <span>Baixar Template</span>
            </a>
        </div>
    </div>

    <!-- Upload Form -->
    <div class="bg-white rounded-2xl shadow-sm p-8 border border-gray-100">
        <h3 class="text-xl font-bold text-gray-800 mb-6">Importar Arquivo CSV</h3>

        <form action="{{ route('admin.products.import.process') }}" method="POST" enctype="multipart/form-data" class="space-y-6">
            @csrf

            <!-- File Upload -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-file-upload text-pink-500 mr-2"></i>Arquivo CSV
                </label>
                <div class="border-2 border-dashed border-gray-300 rounded-xl p-8 text-center hover:border-pink-400 transition">
                    <input type="file" name="csv_file" accept=".csv,.txt" id="csv_file" class="hidden" required>
                    <label for="csv_file" class="cursor-pointer">
                        <div class="w-16 h-16 bg-pink-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-cloud-upload-alt text-pink-500 text-2xl"></i>
                        </div>
                        <p class="text-gray-700 font-medium mb-1">Clique para selecionar o arquivo</p>
                        <p class="text-gray-500 text-sm">ou arraste e solte aqui</p>
                        <p class="text-gray-400 text-xs mt-2">Formatos aceitos: CSV, TXT (máx. 10MB)</p>
                        <p id="file-name" class="text-pink-600 font-medium mt-4 hidden"></p>
                    </label>
                </div>
            </div>

            <!-- Expected Columns -->
            <div class="bg-gray-50 rounded-xl p-4">
                <h4 class="font-semibold text-gray-800 mb-3">Colunas Esperadas:</h4>
                <div class="grid grid-cols-3 gap-3 text-sm">
                    <div class="flex items-center space-x-2">
                        <span class="w-2 h-2 bg-pink-500 rounded-full"></span>
                        <code class="text-gray-600">name</code>
                    </div>
                    <div class="flex items-center space-x-2">
                        <span class="w-2 h-2 bg-pink-500 rounded-full"></span>
                        <code class="text-gray-600">sku</code>
                    </div>
                    <div class="flex items-center space-x-2">
                        <span class="w-2 h-2 bg-pink-500 rounded-full"></span>
                        <code class="text-gray-600">category</code>
                    </div>
                    <div class="flex items-center space-x-2">
                        <span class="w-2 h-2 bg-pink-500 rounded-full"></span>
                        <code class="text-gray-600">price</code>
                    </div>
                    <div class="flex items-center space-x-2">
                        <span class="w-2 h-2 bg-pink-500 rounded-full"></span>
                        <code class="text-gray-600">discount_price</code>
                    </div>
                    <div class="flex items-center space-x-2">
                        <span class="w-2 h-2 bg-pink-500 rounded-full"></span>
                        <code class="text-gray-600">stock</code>
                    </div>
                    <div class="flex items-center space-x-2">
                        <span class="w-2 h-2 bg-pink-500 rounded-full"></span>
                        <code class="text-gray-600">description</code>
                    </div>
                    <div class="flex items-center space-x-2">
                        <span class="w-2 h-2 bg-pink-500 rounded-full"></span>
                        <code class="text-gray-600">is_featured</code>
                    </div>
                    <div class="flex items-center space-x-2">
                        <span class="w-2 h-2 bg-pink-500 rounded-full"></span>
                        <code class="text-gray-600">is_active</code>
                    </div>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="flex items-center justify-between pt-4">
                <a href="{{ route('admin.products.index') }}" class="text-gray-600 hover:text-gray-800 font-medium">
                    <i class="fas fa-arrow-left mr-2"></i>Voltar
                </a>
                <button type="submit"
                        class="px-8 py-4 bg-gradient-to-r from-pink-500 to-rose-500 text-white font-bold rounded-xl hover:from-pink-600 hover:to-rose-600 transition flex items-center space-x-2 shadow-lg">
                    <i class="fas fa-upload"></i>
                    <span>Importar Produtos</span>
                </button>
            </div>
        </form>
    </div>

    <!-- Info -->
    <div class="mt-8 bg-blue-50 rounded-xl p-4 border border-blue-100">
        <div class="flex items-start space-x-3">
            <i class="fas fa-lightbulb text-blue-500 mt-1"></i>
            <div class="text-sm text-blue-800">
                <p class="font-semibold mb-1">Dica:</p>
                <ul class="space-y-1 text-blue-700">
                    <li>• O slug será gerado automaticamente a partir do nome</li>
                    <li>• Produtos com o mesmo SKU serão atualizados em vez de duplicados</li>
                    <li>• A categoria deve existir no sistema para ser associada</li>
                    <li>• Use <code>1</code> ou <code>true</code> para is_featured e is_active</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
    // File input display
    document.getElementById('csv_file').addEventListener('change', function(e) {
        const fileName = e.target.files[0]?.name;
        const fileNameDisplay = document.getElementById('file-name');
        if (fileName) {
            fileNameDisplay.textContent = 'Arquivo selecionado: ' + fileName;
            fileNameDisplay.classList.remove('hidden');
        }
    });
</script>
@endsection
