<!-- Formulário de Produto -->
<div class="bg-white rounded-lg shadow-sm p-6">
    <form method="POST" action="{{ $product ? route('admin.products.update', $product) : route('admin.products.store') }}" enctype="multipart/form-data">
        @csrf
        @if($product)
            @method('PUT')
        @endif

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Coluna Principal -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Informações Básicas -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Informações Básicas</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Nome do Produto *</label>
                            <input type="text" name="name" value="{{ old('name', $product->name ?? '') }}" required
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">SKU</label>
                            <input type="text" name="sku" value="{{ old('sku', $product->sku ?? '') }}"
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Slug</label>
                            <input type="text" name="slug" value="{{ old('slug', $product->slug ?? '') }}"
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Categoria</label>
                            <select name="category_id" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="">Selecione...</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ old('category_id', $product->category_id ?? '') == $category->id ? 'selected' : '' }}>
                                        {{ $category->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Marca</label>
                            <input type="text" name="brand" value="{{ old('brand', $product->brand ?? '') }}"
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>
                </div>

                <!-- Descrições -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Descrições</h3>
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Descrição Curta</label>
                            <textarea name="short_description" rows="2"
                                      class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('short_description', $product->short_description ?? '') }}</textarea>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Descrição Completa</label>
                            <textarea name="description" rows="6"
                                      class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('description', $product->description ?? '') }}</textarea>
                        </div>
                    </div>
                </div>

                <!-- Detalhes do Produto -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Detalhes do Produto</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Peso (g)</label>
                            <input type="number" step="0.01" name="weight" value="{{ old('weight', $product->weight ?? '') }}"
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Sabor</label>
                            <input type="text" name="flavor" value="{{ old('flavor', $product->flavor ?? '') }}"
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Porções</label>
                            <input type="number" name="servings" value="{{ old('servings', $product->servings ?? '') }}"
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div class="md:col-span-3">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Ingredientes</label>
                            <textarea name="ingredients" rows="2"
                                      class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('ingredients', $product->ingredients ?? '') }}</textarea>
                        </div>
                        <div class="md:col-span-3">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Modo de Uso</label>
                            <textarea name="usage_instructions" rows="2"
                                      class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('usage_instructions', $product->usage_instructions ?? '') }}</textarea>
                        </div>
                        <div class="md:col-span-3">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Advertências</label>
                            <textarea name="warnings" rows="2"
                                      class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('warnings', $product->warnings ?? '') }}</textarea>
                        </div>
                    </div>
                </div>

                <!-- Variantes -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Variantes (Sabor, Tamanho, Cor, etc)</h3>
                    @foreach($variants as $type => $variantList)
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                {{ $variantList->first()->name ?? ucfirst($type) }}
                            </label>
                            <div class="space-y-2" id="variant-{{ $type }}-container">
                                @if($product && $product->variants->where('type', $type)->count() > 0)
                                    @foreach($product->variants->where('type', $type) as $existingVariant)
                                        @php
                                            $pivot = $existingVariant->pivot;
                                        @endphp
                                        <div class="flex gap-2 items-center variant-row">
                                            <input type="text" name="variant_data[{{ $existingVariant->id }}][]"
                                                   placeholder="Valor (ex: Morango)"
                                                   value="{{ $pivot->value }}"
                                                   class="flex-1 px-4 py-2 border rounded-lg">
                                            <input type="number" step="0.01" name="variant_data[{{ $existingVariant->id }}][]"
                                                   placeholder="Ajuste Preço"
                                                   value="{{ $pivot->price_adjustment }}"
                                                   class="w-32 px-4 py-2 border rounded-lg">
                                            <input type="text" name="variant_data[{{ $existingVariant->id }}][]"
                                                   placeholder="SKU"
                                                   value="{{ $pivot->sku }}"
                                                   class="w-32 px-4 py-2 border rounded-lg">
                                            <input type="number" name="variant_data[{{ $existingVariant->id }}][]"
                                                   placeholder="Estoque"
                                                   value="{{ $pivot->stock }}"
                                                   class="w-24 px-4 py-2 border rounded-lg">
                                            <button type="button" onclick="this.parentElement.remove()" class="text-red-600 hover:text-red-800">
                                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                                </svg>
                                            </button>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            <button type="button" onclick="addVariantRow('{{ $type }}', {{ $variantList->first()->id }})"
                                    class="mt-2 px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300 transition text-sm">
                                + Adicionar {{ $variantList->first()->name ?? ucfirst($type) }}
                            </button>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Coluna Lateral -->
            <div class="space-y-6">
                <!-- Imagens -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Imagens (máx. 6)</h3>
                    <div class="mb-4">
                        <input type="file" name="images[]" multiple accept="image/*"
                               class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                               onchange="previewImages(this)">
                    </div>
                    <div id="image-preview" class="grid grid-cols-3 gap-2 mb-4"></div>
                    @if($product && $product->images->count() > 0)
                        <div class="grid grid-cols-3 gap-2">
                            @foreach($product->images as $image)
                                <div class="relative group">
                                    <img src="{{ asset('storage/' . $image->image_path) }}" class="w-full h-24 object-cover rounded">
                                    @if($image->is_main)
                                        <span class="absolute top-1 left-1 px-2 py-1 bg-blue-600 text-white text-xs rounded">Principal</span>
                                    @endif
                                    <input type="checkbox" name="delete_images[]" value="{{ $image->id }}"
                                           class="absolute top-1 right-1 w-5 h-5 accent-red-600"
                                           title="Marcar para deletar">
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>

                <!-- Vídeo -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Vídeo</h3>
                    <div class="space-y-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Tipo</label>
                            <select name="video_type" class="w-full px-4 py-2 border rounded-lg">
                                <option value="">Nenhum</option>
                                <option value="youtube" {{ old('video_type', $product->video_type ?? '') == 'youtube' ? 'selected' : '' }}>YouTube</option>
                                <option value="vimeo" {{ old('video_type', $product->video_type ?? '') == 'vimeo' ? 'selected' : '' }}>Vimeo</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">URL do Vídeo</label>
                            <input type="text" name="video_url" value="{{ old('video_url', $product->video_url ?? '') }}"
                                   placeholder="https://youtube.com/watch?v=..."
                                   class="w-full px-4 py-2 border rounded-lg">
                        </div>
                    </div>
                </div>

                <!-- Preço e Estoque -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Preço e Estoque</h3>
                    <div class="space-y-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Preço *</label>
                            <input type="number" step="0.01" name="price" value="{{ old('price', $product->price ?? '') }}" required
                                   class="w-full px-4 py-2 border rounded-lg">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Preço com Desconto</label>
                            <input type="number" step="0.01" name="discount_price" value="{{ old('discount_price', $product->discount_price ?? '') }}"
                                   class="w-full px-4 py-2 border rounded-lg">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Estoque</label>
                            <input type="number" name="stock" value="{{ old('stock', $product->stock ?? '') }}"
                                   class="w-full px-4 py-2 border rounded-lg">
                        </div>
                    </div>
                </div>

                <!-- Status -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Status</h3>
                    <div class="space-y-3">
                        <label class="flex items-center">
                            <input type="checkbox" name="is_active" {{ old('is_active', $product->is_active ?? 1) ? 'checked' : '' }}
                                   class="w-4 h-4 text-blue-600 rounded">
                            <span class="ml-2 text-sm">Produto Ativo</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" name="is_featured" {{ old('is_featured', $product->is_featured ?? 0) ? 'checked' : '' }}
                                   class="w-4 h-4 text-blue-600 rounded">
                            <span class="ml-2 text-sm">Produto em Destaque</span>
                        </label>
                    </div>
                </div>

                <!-- SEO -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">SEO</h3>
                    <div class="space-y-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Meta Title</label>
                            <input type="text" name="meta_title" value="{{ old('meta_title', $product->meta_title ?? '') }}"
                                   class="w-full px-4 py-2 border rounded-lg">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Meta Description</label>
                            <textarea name="meta_description" rows="2"
                                      class="w-full px-4 py-2 border rounded-lg">{{ old('meta_description', $product->meta_description ?? '') }}</textarea>
                        </div>
                    </div>
                </div>

                <!-- Botões -->
                <div class="flex gap-3">
                    <button type="submit" class="flex-1 px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">
                        {{ $product ? 'Atualizar' : 'Criar' }} Produto
                    </button>
                    <a href="{{ route('admin.products.index') }}" class="px-4 py-2 bg-gray-300 text-gray-700 rounded-lg hover:bg-gray-400 transition">
                        Cancelar
                    </a>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
function addVariantRow(type, variantId) {
    const container = document.getElementById('variant-' + type + '-container');
    const newRow = document.createElement('div');
    newRow.className = 'flex gap-2 items-center variant-row';
    newRow.innerHTML = `
        <input type="text" name="variant_data[${variantId}][]" placeholder="Valor (ex: Morango)"
               class="flex-1 px-4 py-2 border rounded-lg">
        <input type="number" step="0.01" name="variant_data[${variantId}][]" placeholder="Ajuste Preço"
               class="w-32 px-4 py-2 border rounded-lg" value="0">
        <input type="text" name="variant_data[${variantId}][]" placeholder="SKU"
               class="w-32 px-4 py-2 border rounded-lg">
        <input type="number" name="variant_data[${variantId}][]" placeholder="Estoque"
               class="w-24 px-4 py-2 border rounded-lg" value="0">
        <button type="button" onclick="this.parentElement.remove()" class="text-red-600 hover:text-red-800">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
            </svg>
        </button>
    `;
    container.appendChild(newRow);
}

function previewImages(input) {
    const preview = document.getElementById('image-preview');
    preview.innerHTML = '';
    if (input.files) {
        Array.from(input.files).forEach((file, index) => {
            if (index < 6) {
                const reader = new FileReader();
                reader.onload = (e) => {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.className = 'w-full h-24 object-cover rounded';
                    preview.appendChild(img);
                };
                reader.readAsDataURL(file);
            }
        });
    }
}
</script>
