@extends('admin.layouts.app')

@section('title', "Pedido #{$order->order_number}")

@section('header', "Pedido #{$order->order_number}")

@section('content')
<div class="max-w-7xl mx-auto">
    <div class="grid lg:grid-cols-3 gap-6">
        <!-- Coluna Principal -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Informações do Pedido -->
            <div class="bg-white rounded-lg shadow-sm p-6">
                <h2 class="text-lg font-semibold mb-4">Informações do Pedido</h2>

                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-600">Número do Pedido</p>
                        <p class="font-medium">{{ $order->order_number }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Data do Pedido</p>
                        <p class="font-medium">{{ $order->created_at->format('d/m/Y H:i') }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Método de Pagamento</p>
                        <p class="font-medium">{{ $order->payment_method_label }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Status do Pagamento</p>
                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium
                            {{ $order->payment_status === 'paid' ? 'bg-green-100 text-green-800' :
                               ($order->payment_status === 'pending' ? 'bg-yellow-100 text-yellow-800' :
                               ($order->payment_status === 'cancelled' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-800')) }}">
                            {{ $order->payment_status_label }}
                        </span>
                    </div>
                    @if($order->gateway_transaction_id)
                        <div>
                            <p class="text-sm text-gray-600">ID da Transação</p>
                            <p class="font-medium text-sm font-mono">{{ $order->gateway_transaction_id }}</p>
                        </div>
                    @endif
                    @if($order->installments)
                        <div>
                            <p class="text-sm text-gray-600">Parcelas</p>
                            <p class="font-medium">{{ $order->installments }}x de R$ {{ number_format($order->installment_value, 2, ',', '.') }}</p>
                        </div>
                    @endif
                </div>

                @if($order->admin_notes)
                    <div class="mt-4 p-3 bg-gray-50 rounded-lg">
                        <p class="text-sm text-gray-600">Observações</p>
                        <p class="text-sm">{{ $order->admin_notes }}</p>
                    </div>
                @endif
            </div>

            <!-- Itens do Pedido -->
            <div class="bg-white rounded-lg shadow-sm p-6">
                <h2 class="text-lg font-semibold mb-4">Itens do Pedido</h2>

                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="border-b">
                            <tr>
                                <th class="text-left py-2 text-sm font-medium text-gray-600">Produto</th>
                                <th class="text-center py-2 text-sm font-medium text-gray-600">Qtd</th>
                                <th class="text-right py-2 text-sm font-medium text-gray-600">Preço</th>
                                <th class="text-right py-2 text-sm font-medium text-gray-600">Subtotal</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y">
                            @foreach($order->items as $item)
                                <tr>
                                    <td class="py-3">
                                        <div>
                                            <p class="font-medium">{{ $item->name }}</p>
                                            <p class="text-xs text-gray-500">{{ $item->type === 'product' ? 'Produto' : 'Combo' }}</p>
                                            @if($item->variant)
                                                <p class="text-xs text-gray-400">{{ json_decode($item->variant, true) ? implode(', ', json_decode($item->variant, true)) : '' }}</p>
                                            @endif
                                        </div>
                                    </td>
                                    <td class="text-center py-3">{{ $item->quantity }}</td>
                                    <td class="text-right py-3">
                                        @if($item->discount_price)
                                            <span class="line-through text-gray-400 text-sm">R$ {{ number_format($item->price, 2, ',', '.') }}</span>
                                            <span class="ml-1">R$ {{ number_format($item->discount_price, 2, ',', '.') }}</span>
                                        @else
                                            R$ {{ number_format($item->price, 2, ',', '.') }}
                                        @endif
                                    </td>
                                    <td class="text-right py-3 font-medium">
                                        R$ {{ number_format($item->subtotal, 2, ',', '.') }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="border-t">
                            <tr>
                                <td colspan="3" class="text-right py-2 text-gray-600">Subtotal</td>
                                <td class="text-right py-2 font-medium">R$ {{ number_format($order->subtotal, 2, ',', '.') }}</td>
                            </tr>
                            @if($order->discount > 0)
                                <tr>
                                    <td colspan="3" class="text-right py-2 text-green-600">Desconto{{ $order->coupon_code ? " ({$order->coupon_code})" : '' }}</td>
                                    <td class="text-right py-2 text-green-600 font-medium">- R$ {{ number_format($order->discount, 2, ',', '.') }}</td>
                                </tr>
                            @endif
                            <tr>
                                <td colspan="3" class="text-right py-2 text-gray-600">Frete</td>
                                <td class="text-right py-2 font-medium">{{ $order->shipping_cost == 0 ? 'GRÁTIS' : 'R$ ' . number_format($order->shipping_cost, 2, ',', '.') }}</td>
                            </tr>
                            <tr class="bg-gray-50">
                                <td colspan="3" class="text-right py-3 font-bold text-lg">Total</td>
                                <td class="text-right py-3 font-bold text-lg text-green-600">R$ {{ number_format($order->total, 2, ',', '.') }}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Status do Pedido -->
            <div class="bg-white rounded-lg shadow-sm p-6">
                <h2 class="text-lg font-semibold mb-4">Status do Pedido</h2>

                <form method="POST" action="{{ route('admin.orders.update', $order) }}">
                    @csrf
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                            <select name="status" class="w-full px-3 py-2 border rounded-lg">
                                <option value="pending" {{ $order->status === 'pending' ? 'selected' : '' }}>Pendente</option>
                                <option value="confirmed" {{ $order->status === 'confirmed' ? 'selected' : '' }}>Confirmado</option>
                                <option value="processing" {{ $order->status === 'processing' ? 'selected' : '' }}>Processando</option>
                                <option value="shipped" {{ $order->status === 'shipped' ? 'selected' : '' }}>Enviado</option>
                                <option value="delivered" {{ $order->status === 'delivered' ? 'selected' : '' }}>Entregue</option>
                                <option value="cancelled" {{ $order->status === 'cancelled' ? 'selected' : '' }}>Cancelado</option>
                            </select>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Código de Rastreio</label>
                            <input type="text" name="tracking_code" value="{{ $order->tracking_code }}"
                                   placeholder="EX: ABC123456789BR"
                                   class="w-full px-3 py-2 border rounded-lg">
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Observações</label>
                            <textarea name="notes" rows="3"
                                      class="w-full px-3 py-2 border rounded-lg">{{ $order->admin_notes }}</textarea>
                        </div>

                        <button type="submit" class="w-full py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                            Atualizar Status
                        </button>
                    </div>
                </form>
            </div>

            <!-- Status de Pagamento -->
            <div class="bg-white rounded-lg shadow-sm p-6">
                <h2 class="text-lg font-semibold mb-4">Status de Pagamento</h2>

                <form method="POST" action="{{ route('admin.orders.payment-status', $order) }}">
                    @csrf
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Pagamento</label>
                        <select name="payment_status" class="w-full px-3 py-2 border rounded-lg">
                            <option value="pending" {{ $order->payment_status === 'pending' ? 'selected' : '' }}>Pendente</option>
                            <option value="paid" {{ $order->payment_status === 'paid' ? 'selected' : '' }}>Pago</option>
                            <option value="cancelled" {{ $order->payment_status === 'cancelled' ? 'selected' : '' }}>Cancelado</option>
                            <option value="refunded" {{ $order->payment_status === 'refunded' ? 'selected' : '' }}>Reembolsado</option>
                        </select>
                    </div>
                    <button type="submit" class="w-full mt-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">
                        Atualizar Pagamento
                    </button>
                </form>
            </div>

            <!-- Dados do Cliente -->
            <div class="bg-white rounded-lg shadow-sm p-6">
                <h2 class="text-lg font-semibold mb-4">Dados do Cliente</h2>

                <div class="space-y-2 text-sm">
                    <div>
                        <p class="text-gray-600">Nome</p>
                        <p class="font-medium">{{ $order->customer_name }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600">E-mail</p>
                        <p class="font-medium">{{ $order->customer_email }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600">Telefone</p>
                        <p class="font-medium">{{ $order->customer_phone }}</p>
                    </div>
                    @if($order->customer_cpf)
                        <div>
                            <p class="text-gray-600">CPF</p>
                            <p class="font-medium">{{ $order->customer_cpf }}</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Endereço de Entrega -->
            <div class="bg-white rounded-lg shadow-sm p-6">
                <h2 class="text-lg font-semibold mb-4">Endereço de Entrega</h2>

                <div class="text-sm">
                    <p class="font-medium">{{ $order->customer_name }}</p>
                    <p>{{ $order->shipping_address }}, {{ $order->shipping_number }}</p>
                    @if($order->shipping_complement)
                        <p>{{ $order->shipping_complement }}</p>
                    @endif
                    <p>{{ $order->shipping_district }}</p>
                    <p>{{ $order->shipping_city }} - {{ $order->shipping_state }}</p>
                    <p>CEP: {{ $order->shipping_zipcode }}</p>
                </div>
            </div>

            <!-- Informações de Pagamento -->
            @if($order->payment_method === 'pix')
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <h2 class="text-lg font-semibold mb-4">PIX</h2>
                    <p class="text-sm text-gray-600">QR Code e Copia e Cola disponíveis na página de sucesso do cliente</p>
                </div>
            @endif

            @if($order->payment_method === 'boleto' && $order->boleto_url)
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <h2 class="text-lg font-semibold mb-4">Boleto</h2>
                    <a href="{{ $order->boleto_url }}" target="_blank" class="text-blue-600 hover:underline text-sm">
                        Ver boleto no Asaas →
                    </a>
                </div>
            @endif
        </div>
    </div>

    <!-- Ações -->
    <div class="mt-6 flex gap-4">
        <a href="{{ route('admin.orders.index') }}" class="px-6 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300">
            Voltar para Pedidos
        </a>
        <a href="{{ route('admin.orders.print', $order) }}" target="_blank" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
            Imprimir
        </a>
    </div>
</div>
@endsection
