<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pedido #{{ $order->order_number }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        @media print {
            body { padding: 0; }
            .no-print { display: none; }
        }
        .header {
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        .header h1 {
            margin: 0 0 5px 0;
            font-size: 24px;
        }
        .section {
            margin-bottom: 20px;
        }
        .section h3 {
            background: #f0f0f0;
            padding: 8px;
            margin: 0 0 10px 0;
            font-size: 14px;
            border-bottom: 1px solid #ddd;
        }
        .info-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
        }
        .info-item label {
            display: block;
            font-weight: bold;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        table th {
            background: #f0f0f0;
            padding: 8px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        table td {
            padding: 8px;
            border-bottom: 1px solid #eee;
        }
        table tfoot tr {
            background: #f9f9f9;
        }
        .total {
            font-size: 16px;
            font-weight: bold;
            color: #2563eb;
        }
        .status {
            padding: 3px 8px;
            border-radius: 4px;
            font-size: 10px;
            text-transform: uppercase;
        }
        .status.paid { background: #dcfce7; color: #166534; }
        .status.pending { background: #fef9c3; color: #854d0e; }
        .status.cancelled { background: #fee2e2; color: #991b1b; }
        .no-print {
            margin-top: 30px;
            text-align: center;
        }
        .no-print button {
            padding: 10px 20px;
            background: #2563eb;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ config('app.name') }}</h1>
        <p>Pedido #{{ $order->order_number }}</p>
        <p>Data: {{ $order->created_at->format('d/m/Y H:i') }}</p>
    </div>

    <div class="section">
        <h3>Cliente</h3>
        <div class="info-grid">
            <div class="info-item">
                <label>Nome:</label>
                {{ $order->customer_name }}
            </div>
            <div class="info-item">
                <label>Email:</label>
                {{ $order->customer_email }}
            </div>
            <div class="info-item">
                <label>Telefone:</label>
                {{ $order->customer_phone }}
            </div>
            @if($order->customer_cpf)
                <div class="info-item">
                    <label>CPF:</label>
                    {{ $order->customer_cpf }}
                </div>
            @endif
        </div>
    </div>

    <div class="section">
        <h3>Endereço de Entrega</h3>
        <p>
            {{ $order->shipping_address }}, {{ $order->shipping_number }}
            @if($order->shipping_complement) - {{ $order->shipping_complement }} @endif
        </p>
        <p>{{ $order->shipping_district }}</p>
        <p>{{ $order->shipping_city }} - {{ $order->shipping_state }}</p>
        <p>CEP: {{ $order->shipping_zipcode }}</p>
    </div>

    <div class="section">
        <h3>Informações do Pedido</h3>
        <div class="info-grid">
            <div class="info-item">
                <label>Status:</label>
                <span class="status {{ $order->status }}">{{ $order->status_label }}</span>
            </div>
            <div class="info-item">
                <label>Pagamento:</label>
                {{ $order->payment_method_label }}
                <span class="status {{ $order->payment_status }}">{{ $order->payment_status_label }}</span>
            </div>
            @if($order->tracking_code)
                <div class="info-item">
                    <label>Rastreio:</label>
                    {{ $order->tracking_code }}
                </div>
            @endif
            @if($order->installments)
                <div class="info-item">
                    <label>Parcelas:</label>
                    {{ $order->installments }}x de R$ {{ number_format($order->installment_value, 2, ',', '.') }}
                </div>
            @endif
        </div>
    </div>

    <div class="section">
        <h3>Itens do Pedido</h3>
        <table>
            <thead>
                <tr>
                    <th>Produto</th>
                    <th>Qtd</th>
                    <th>Preço</th>
                    <th>Subtotal</th>
                </tr>
            </thead>
            <tbody>
                @foreach($order->items as $item)
                    <tr>
                        <td>
                            <strong>{{ $item->name }}</strong>
                            @if($item->variant)
                                <br><small>{{ json_decode($item->variant, true) ? implode(', ', json_decode($item->variant, true)) : '' }}</small>
                            @endif
                        </td>
                        <td>{{ $item->quantity }}</td>
                        <td>R$ {{ number_format($item->discount_price ?? $item->price, 2, ',', '.') }}</td>
                        <td>R$ {{ number_format($item->subtotal, 2, ',', '.') }}</td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="3"><strong>Subtotal</strong></td>
                    <td>R$ {{ number_format($order->subtotal, 2, ',', '.') }}</td>
                </tr>
                @if($order->discount > 0)
                    <tr>
                        <td colspan="3"><strong>Desconto{{ $order->coupon_code ? " ({$order->coupon_code})" : '' }}</strong></td>
                        <td>- R$ {{ number_format($order->discount, 2, ',', '.') }}</td>
                    </tr>
                @endif
                <tr>
                    <td colspan="3"><strong>Frete</strong></td>
                    <td>{{ $order->shipping_cost == 0 ? 'GRÁTIS' : 'R$ ' . number_format($order->shipping_cost, 2, ',', '.') }}</td>
                </tr>
                <tr>
                    <td colspan="3"><strong class="total">Total</strong></td>
                    <td class="total">R$ {{ number_format($order->total, 2, ',', '.') }}</td>
                </tr>
            </tfoot>
        </table>
    </div>

    @if($order->admin_notes)
        <div class="section">
            <h3>Observações</h3>
            <p>{{ $order->admin_notes }}</p>
        </div>
    @endif

    <div class="no-print">
        <button onclick="window.print()">Imprimir</button>
    </div>

    <script>
    window.addEventListener('load', function() {
        setTimeout(function() {
            window.print();
        }, 500);
    });
    </script>
</body>
</html>
