@extends('admin.layouts.app')

@section('title', $combo->name)

@section('header', $combo->name)

@section('content')
<div class="mb-4">
    <a href="{{ route('admin.combos.index') }}" class="text-blue-600 hover:text-blue-800">
        &larr; Voltar para Combos
    </a>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Informações do Combo -->
    <div class="lg:col-span-2 space-y-6">
        <!-- Imagem -->
        @if($combo->image)
            <div class="bg-white rounded-lg shadow-sm p-6">
                <img src="{{ asset('storage/' . $combo->image) }}" alt="{{ $combo->name }}" class="w-full h-80 object-cover rounded">
            </div>
        @endif

        <!-- Descrição -->
        @if($combo->description)
            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold mb-4">Descrição</h3>
                <div class="prose max-w-none">
                    {!! nl2br(e($combo->description)) !!}
                </div>
            </div>
        @endif

        <!-- Produtos do Combo -->
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="text-lg font-semibold mb-4">Produtos Incluídos</h3>
            <div class="space-y-3">
                @foreach($combo->items as $item)
                    <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                        <div>
                            <p class="font-medium">{{ $item->product->name }}</p>
                            <p class="text-sm text-gray-500">SKU: {{ $item->product->sku ?? 'N/A' }}</p>
                        </div>
                        <div class="text-right">
                            <p class="font-medium">x{{ $item->quantity }}</p>
                            <p class="text-sm text-gray-500">R$ {{ number_format($item->product->price * $item->quantity, 2, ',', '.') }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>

        <!-- Brindes -->
        @if($combo->gifts && count($combo->gifts) > 0)
            <div class="bg-white rounded-lg shadow-sm p-6">
                <h3 class="text-lg font-semibold mb-4">Brindes Incluídos</h3>
                <ul class="space-y-2">
                    @foreach($combo->gifts as $gift)
                        <li class="flex items-center text-gray-700">
                            <svg class="w-5 h-5 mr-2 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            {{ $gift }}
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif
    </div>

    <!-- Sidebar -->
    <div class="space-y-6">
        <!-- Ações -->
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="text-lg font-semibold mb-4">Ações</h3>
            <div class="space-y-3">
                <a href="{{ route('admin.combos.edit', $combo) }}"
                   class="block w-full px-4 py-2 bg-blue-600 text-white text-center rounded-lg hover:bg-blue-700 transition">
                    Editar Combo
                </a>
                <form method="POST" action="{{ route('admin.combos.destroy', $combo) }}"
                      onsubmit="return confirm('Deseja realmente deletar este combo?');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="w-full px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 transition">
                        Deletar Combo
                    </button>
                </form>
            </div>
        </div>

        <!-- Preços -->
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="text-lg font-semibold mb-4">Preços</h3>
            <dl class="space-y-3">
                <div class="flex justify-between">
                    <span class="text-gray-500">Preço Original</span>
                    <span class="font-medium line-through text-gray-400">R$ {{ number_format($combo->original_price, 2, ',', '.') }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Preço com Desconto</span>
                    <span class="font-medium text-green-600 text-lg">R$ {{ number_format($combo->price, 2, ',', '.') }}</span>
                </div>
                @if($combo->pix_price)
                    <div class="flex justify-between">
                        <span class="text-gray-500">Preço PIX</span>
                        <span class="font-medium text-blue-600">R$ {{ number_format($combo->pix_price, 2, ',', '.') }}</span>
                    </div>
                @endif
                <div class="flex justify-between">
                    <span class="text-gray-500">Desconto</span>
                    <span class="font-medium text-green-600">{{ $combo->discount_percentage }}% OFF</span>
                </div>
                @if($combo->max_installments > 1)
                    <div class="flex justify-between">
                        <span class="text-gray-500">Parcelamento</span>
                        <span class="font-medium">{{ $combo->max_installments }}x de R$ {{ number_format($combo->installment_value, 2, ',', '.') }}</span>
                    </div>
                @endif
                @if($combo->free_shipping_threshold)
                    <div class="flex justify-between">
                        <span class="text-gray-500">Frete Grátis</span>
                        <span class="font-medium">Acima de R$ {{ number_format($combo->free_shipping_threshold, 2, ',', '.') }}</span>
                    </div>
                @endif
            </dl>
        </div>

        <!-- Status -->
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="text-lg font-semibold mb-4">Status</h3>
            <dl class="space-y-3">
                <div class="flex justify-between items-center">
                    <span class="text-gray-500">Status</span>
                    @if($combo->is_active)
                        <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">Ativo</span>
                    @else
                        <span class="px-2 py-1 text-xs rounded-full bg-gray-100 text-gray-800">Inativo</span>
                    @endif
                </div>
                @if($combo->is_featured)
                    <div class="flex justify-between items-center">
                        <span class="text-gray-500">Destaque</span>
                        <span class="px-2 py-1 text-xs rounded-full bg-yellow-100 text-yellow-800">Sim</span>
                    </div>
                @endif
            </dl>
        </div>

        <!-- Informações de Sistema -->
        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="text-lg font-semibold mb-4">Informações</h3>
            <dl class="space-y-2 text-sm">
                <div class="flex justify-between">
                    <span class="text-gray-500">Slug</span>
                    <span class="font-mono text-xs">{{ $combo->slug }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">ID</span>
                    <span class="font-mono">#{{ $combo->id }}</span>
                </div>
            </dl>
        </div>
    </div>
</div>
@endsection
