<div class="bg-white rounded-lg shadow-sm p-6">
    <form method="POST" action="{{ $combo ? route('admin.combos.update', $combo) : route('admin.combos.store') }}" enctype="multipart/form-data">
        @csrf
        @if($combo)
            @method('PUT')
        @endif

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Coluna Principal -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Informações Básicas -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Informações do Combo</h3>
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Nome do Combo *</label>
                            <input type="text" name="name" value="{{ old('name', $combo->name ?? '') }}" required
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                   placeholder="Ex: Kit 3 Colágenos">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Slug</label>
                            <input type="text" name="slug" value="{{ old('slug', $combo->slug ?? '') }}"
                                   class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Descrição</label>
                            <textarea name="description" rows="3"
                                      class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('description', $combo->description ?? '') }}</textarea>
                        </div>
                    </div>
                </div>

                <!-- Seleção de Produtos -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Produtos do Combo</h3>
                    <div id="products-container" class="space-y-3">
                        @if($combo && $combo->items->count() > 0)
                            @foreach($combo->items as $item)
                                <div class="flex gap-3 items-center product-row">
                                    <select name="products[{{ $loop->index }}][id]" required
                                            class="flex-1 px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                        <option value="">Selecione um produto...</option>
                                        @foreach($products as $product)
                                            <option value="{{ $product->id }}" {{ $product->id == $item->product_id ? 'selected' : '' }}>
                                                {{ $product->name }} - R$ {{ number_format($product->price, 2, ',', '.') }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <input type="number" name="products[{{ $loop->index }}][quantity]" value="{{ $item->quantity }}" min="1" required
                                           class="w-24 px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                           placeholder="Qtd">
                                    <button type="button" onclick="this.parentElement.remove()" class="text-red-600 hover:text-red-800">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                        </svg>
                                    </button>
                                </div>
                            @endforeach
                        @else
                            <div class="flex gap-3 items-center product-row">
                                <select name="products[0][id]" required
                                        class="flex-1 px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                                    <option value="">Selecione um produto...</option>
                                    @foreach($products as $product)
                                        <option value="{{ $product->id }}">{{ $product->name }} - R$ {{ number_format($product->price, 2, ',', '.') }}</option>
                                    @endforeach
                                </select>
                                <input type="number" name="products[0][quantity]" value="1" min="1" required
                                       class="w-24 px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                                       placeholder="Qtd">
                                <button type="button" onclick="this.parentElement.remove()" class="text-red-600 hover:text-red-800">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                    </svg>
                                </button>
                            </div>
                        @endif
                    </div>
                    <button type="button" onclick="addProductRow()"
                            class="mt-3 px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300 transition text-sm">
                        + Adicionar Produto
                    </button>
                </div>

                <!-- Brindes -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Brindes Incluídos</h3>
                    <p class="text-sm text-gray-500 mb-3">Lista os brindes que acompanham este combo (ex: 2 Sachês, 1 Creme)</p>
                    <div id="gifts-container" class="space-y-2">
                        @if($combo && $combo->gifts)
                            @foreach($combo->gifts as $gift)
                                <div class="flex gap-2 gift-row">
                                    <input type="text" name="gifts[]" value="{{ $gift }}"
                                           class="flex-1 px-4 py-2 border rounded-lg" placeholder="Ex: 2 Sachês de Sérum">
                                    <button type="button" onclick="this.parentElement.remove()" class="text-red-600 hover:text-red-800">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                        </svg>
                                    </button>
                                </div>
                            @endforeach
                        @endif
                    </div>
                    <button type="button" onclick="addGiftRow()"
                            class="mt-3 px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300 transition text-sm">
                        + Adicionar Brinde
                    </button>
                </div>
            </div>

            <!-- Coluna Lateral -->
            <div class="space-y-6">
                <!-- Imagem -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Imagem do Combo</h3>
                    @if($combo && $combo->image)
                        <div class="mb-4">
                            <img src="{{ asset('storage/' . $combo->image) }}" class="w-full h-48 object-cover rounded">
                            <label class="flex items-center mt-2">
                                <input type="checkbox" name="delete_image" value="1" class="w-4 h-4 text-red-600 rounded">
                                <span class="ml-2 text-sm text-red-600">Deletar imagem</span>
                            </label>
                        </div>
                    @endif
                    <input type="file" name="image" accept="image/*"
                           class="w-full px-4 py-2 border rounded-lg">
                </div>

                <!-- Vídeo -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Vídeo (opcional)</h3>
                    <input type="text" name="video_url" value="{{ old('video_url', $combo->video_url ?? '') }}"
                           placeholder="URL do vídeo (YouTube/Vimeo)"
                           class="w-full px-4 py-2 border rounded-lg">
                </div>

                <!-- Preços -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Preços</h3>
                    <div class="space-y-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Preço Original *</label>
                            <input type="number" step="0.01" name="original_price" value="{{ old('original_price', $combo->original_price ?? '') }}" required
                                   class="w-full px-4 py-2 border rounded-lg" placeholder="199.90">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Preço com Desconto *</label>
                            <input type="number" step="0.01" name="price" value="{{ old('price', $combo->price ?? '') }}" required
                                   class="w-full px-4 py-2 border rounded-lg" placeholder="89.90">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Preço PIX (opcional)</label>
                            <input type="number" step="0.01" name="pix_price" value="{{ old('pix_price', $combo->pix_price ?? '') }}"
                                   class="w-full px-4 py-2 border rounded-lg" placeholder="79.90">
                        </div>
                    </div>
                </div>

                <!-- Parcelamento -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Parcelamento</h3>
                    <div class="space-y-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Máximo de Parcelas</label>
                            <select name="max_installments" class="w-full px-4 py-2 border rounded-lg">
                                @for($i = 1; $i <= 12; $i++)
                                    <option value="{{ $i }}" {{ old('max_installments', $combo->max_installments ?? 1) == $i ? 'selected' : '' }}>
                                        {{ $i }}x
                                    </option>
                                @endfor
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Valor Mínimo da Parcela</label>
                            <input type="number" step="0.01" name="min_installment_value" value="{{ old('min_installment_value', $combo->min_installment_value ?? '') }}"
                                   class="w-full px-4 py-2 border rounded-lg" placeholder="10.00">
                        </div>
                    </div>
                </div>

                <!-- Frete -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Frete</h3>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Frete Grátis Acima de (R$)</label>
                        <input type="number" name="free_shipping_threshold" value="{{ old('free_shipping_threshold', $combo->free_shipping_threshold ?? '') }}"
                               class="w-full px-4 py-2 border rounded-lg" placeholder="247.00">
                    </div>
                </div>

                <!-- Status -->
                <div class="bg-gray-50 p-4 rounded-lg">
                    <h3 class="text-lg font-semibold mb-4">Status</h3>
                    <div class="space-y-3">
                        <label class="flex items-center">
                            <input type="checkbox" name="is_active" {{ old('is_active', $combo->is_active ?? 1) ? 'checked' : '' }}
                                   class="w-4 h-4 text-blue-600 rounded">
                            <span class="ml-2 text-sm">Combo Ativo</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" name="is_featured" {{ old('is_featured', $combo->is_featured ?? 0) ? 'checked' : '' }}
                                   class="w-4 h-4 text-blue-600 rounded">
                            <span class="ml-2 text-sm">Combo em Destaque</span>
                        </label>
                    </div>
                </div>

                <!-- Botões -->
                <div class="flex gap-3">
                    <button type="submit" class="flex-1 px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">
                        {{ $combo ? 'Atualizar' : 'Criar' }} Combo
                    </button>
                    <a href="{{ route('admin.combos.index') }}" class="px-4 py-2 bg-gray-300 text-gray-700 rounded-lg hover:bg-gray-400 transition">
                        Cancelar
                    </a>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
let productRowIndex = {{ $combo ? $combo->items->count() : 1 }};
const productsData = @json($products);

function addProductRow() {
    const container = document.getElementById('products-container');
    const newRow = document.createElement('div');
    newRow.className = 'flex gap-3 items-center product-row';

    let options = '<option value="">Selecione um produto...</option>';
    productsData.forEach(product => {
        options += `<option value="${product.id}">${product.name} - R$ ${parseFloat(product.price).toFixed(2).replace('.', ',')}</option>`;
    });

    newRow.innerHTML = `
        <select name="products[${productRowIndex}][id]" required
                class="flex-1 px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            ${options}
        </select>
        <input type="number" name="products[${productRowIndex}][quantity]" value="1" min="1" required
               class="w-24 px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
               placeholder="Qtd">
        <button type="button" onclick="this.parentElement.remove()" class="text-red-600 hover:text-red-800">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
            </svg>
        </button>
    `;
    container.appendChild(newRow);
    productRowIndex++;
}

function addGiftRow() {
    const container = document.getElementById('gifts-container');
    const newRow = document.createElement('div');
    newRow.className = 'flex gap-2 gift-row';
    newRow.innerHTML = `
        <input type="text" name="gifts[]"
               class="flex-1 px-4 py-2 border rounded-lg" placeholder="Ex: 2 Sachês de Sérum">
        <button type="button" onclick="this.parentElement.remove()" class="text-red-600 hover:text-red-800">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
            </svg>
        </button>
    `;
    container.appendChild(newRow);
}
</script>
