<?php

namespace Database\Seeders;

use App\Models\Testimonial;
use Illuminate\Database\Seeder;

class TestimonialSeeder extends Seeder
{
    public function run(): void
    {
        $testimonials = [
            [
                'name' => 'Carlos Eduardo',
                'rating' => 5,
                'comment' => 'Produtos de excelente qualidade! O Whey Protein é muito bom e o atendimento é impecável. Super recomendo!',
                'photo_url' => null,
            ],
            [
                'name' => 'Ana Paula Silva',
                'rating' => 5,
                'comment' => 'Comprei o termogênico e em duas semanas já vi resultados. A entrega foi super rápida e veio tudo certinho.',
                'photo_url' => null,
            ],
            [
                'name' => 'Roberto Santos',
                'rating' => 5,
                'comment' => 'Melhor loja de suplementos que já comprei! Preços justos e produtos originais. Já estou na terceira compra.',
                'photo_url' => null,
            ],
            [
                'name' => 'Juliana Mendes',
                'rating' => 4,
                'comment' => 'Gostei muito dos produtos. O pré-treino é muito bom, dá muita energia. Só o frete que demorou um pouco.',
                'photo_url' => null,
            ],
            [
                'name' => 'Marcos Vinícius',
                'rating' => 5,
                'comment' => 'A creatina é top! Já usei várias marcas e essa tem a melhor qualidade que já vi. Com certeza vou comprar mais.',
                'photo_url' => null,
            ],
            [
                'name' => 'Fernanda Costa',
                'rating' => 5,
                'comment' => 'Atendimento nota 10! Tive dúvidas sobre qual produto comprar e foram super atenciosos. Os produtos chegaram antes do prazo.',
                'photo_url' => null,
            ],
            [
                'name' => 'Lucas Oliveira',
                'rating' => 5,
                'comment' => 'Produtos originais com os melhores preços do mercado. Já indiquei para todos os amigos da academia!',
                'photo_url' => null,
            ],
            [
                'name' => 'Patrícia Almeida',
                'rating' => 4,
                'comment' => 'Comprei o multivitamínico e estou amando. Sinto mais energia durante o dia. Recomendo!',
                'photo_url' => null,
            ],
        ];

        foreach ($testimonials as $testimonial) {
            Testimonial::create(array_merge($testimonial, ['is_active' => true]));
        }
    }
}
