<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Proteínas',
                'slug' => 'proteinas',
                'description' => 'Whey Protein, Caseína e outras fontes de proteína para crescimento muscular.',
            ],
            [
                'name' => 'Creatina',
                'slug' => 'creatina',
                'description' => 'Creatina monohidratada e outras formas para aumentar força e performance.',
            ],
            [
                'name' => 'Aminoácidos',
                'slug' => 'aminoacidos',
                'description' => 'BCAAs, glutamina e outros aminoácidos essenciais para recuperação.',
            ],
            [
                'name' => 'Termogênicos',
                'slug' => 'termogenicos',
                'description' => 'Suplementos para acelerar o metabolismo e queima de gordura.',
            ],
            [
                'name' => 'Vitaminas e Minerais',
                'slug' => 'vitaminas-minerais',
                'description' => 'Multivitamínicos e minerais essenciais para saúde e bem-estar.',
            ],
            [
                'name' => 'Pré-Treino',
                'slug' => 'pre-treino',
                'description' => 'Suplementos para aumentar energia, foco e performance nos treinos.',
            ],
        ];

        foreach ($categories as $category) {
            Category::create(array_merge($category, ['is_active' => true]));
        }
    }
}
