<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if admin already exists
        $existingAdmin = User::where('email', 'admin@bella.com')->first();

        if (!$existingAdmin) {
            User::create([
                'name' => 'Admin',
                'email' => 'admin@bella.com',
                'password' => Hash::make('password'),
                'is_admin' => true,
            ]);

            $this->command->info('✅ Admin user created successfully!');
            $this->command->info('Email: admin@bella.com');
            $this->command->info('Password: password');
        } else {
            $this->command->info('ℹ️ Admin user already exists.');
        }
    }
}
