<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->string('video_url')->nullable()->after('description'); // URL do vídeo (YouTube/Vimeo)
            $table->string('video_type')->nullable()->after('video_url'); // youtube, vimeo, upload
            $table->integer('max_images')->default(6)->after('video_type'); // máximo de imagens permitidas
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['video_url', 'video_type', 'max_images']);
        });
    }
};
