<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_number')->unique();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');

            // Dados do cliente
            $table->string('customer_name');
            $table->string('customer_email');
            $table->string('customer_phone');
            $table->string('customer_cpf')->nullable();

            // Dados de entrega
            $table->string('shipping_zipcode');
            $table->string('shipping_address');
            $table->string('shipping_number');
            $table->string('shipping_complement')->nullable();
            $table->string('shipping_district');
            $table->string('shipping_city');
            $table->string('shipping_state');

            // Valores
            $table->decimal('subtotal', 10, 2);
            $table->decimal('shipping_cost', 10, 2)->default(0);
            $table->decimal('discount', 10, 2)->default(0);
            $table->decimal('total', 10, 2);

            // Pagamento
            $table->string('payment_method'); // pix, credit_card, boleto
            $table->string('payment_status')->default('pending'); // pending, paid, cancelled, refunded
            $table->string('gateway')->nullable(); // asaas, mercadopago
            $table->string('gateway_transaction_id')->nullable();
            $table->string('gateway_payment_link')->nullable();
            $table->string('pix_qr_code')->nullable();
            $table->string('pix_copy_paste')->nullable();
            $table->string('boleto_url')->nullable();
            $table->string('boleto_barcode')->nullable();

            // Status
            $table->string('status')->default('pending'); // pending, confirmed, processing, shipped, delivered, cancelled
            $table->string('tracking_code')->nullable();

            // Cupom
            $table->foreignId('coupon_id')->nullable()->constrained()->onDelete('set null');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
