<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('combos', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->decimal('original_price', 10, 2); // preço sem desconto
            $table->decimal('price', 10, 2); // preço com desconto
            $table->decimal('pix_price', 10, 2)->nullable(); // preço no pix
            $table->integer('max_installments')->default(1); // máximo de parcelas
            $table->decimal('min_installment_value', 10, 2)->default(10); // valor mínimo da parcela
            $table->boolean('is_active')->default(true);
            $table->boolean('is_featured')->default(false);
            $table->integer('free_shipping_threshold')->nullable(); // frete grátis acima de X
            $table->string('image')->nullable();
            $table->string('video_url')->nullable(); // URL do vídeo (YouTube/Vimeo)
            $table->json('gifts')->nullable(); // brindes incluídos
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('combos');
    }
};
