<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Variant extends Model
{
    protected $fillable = [
        'name',
        'type',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Tipos de variantes disponíveis
    const TYPE_FLAVOR = 'flavor';
    const TYPE_SIZE = 'size';
    const TYPE_COLOR = 'color';

    public static function getTypes(): array
    {
        return [
            self::TYPE_FLAVOR => 'Sabor',
            self::TYPE_SIZE => 'Tamanho',
            self::TYPE_COLOR => 'Cor',
        ];
    }

    public function products()
    {
        return $this->belongsToMany(Product::class, 'product_variants')
            ->withPivot('value', 'price_adjustment', 'sku', 'stock', 'is_active', 'sort_order')
            ->withTimestamps();
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeByType($query, $type)
    {
        return $query->where('type', $type);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }
}
