<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    protected $table = 'order_items';

    protected $fillable = [
        'order_id',
        'product_id',
        'combo_id',
        'product_name',
        'product_sku',
        'selected_variants',
        'quantity',
        'unit_price',
        'subtotal',
    ];

    protected $casts = [
        'selected_variants' => 'array',
        'unit_price' => 'decimal:2',
        'subtotal' => 'decimal:2',
    ];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function combo()
    {
        return $this->belongsTo(Combo::class);
    }

    public function getVariantDisplayAttribute(): string
    {
        if (!$this->selected_variants) {
            return '';
        }

        $variants = [];
        foreach ($this->selected_variants as $key => $value) {
            $variants[] = "{$key}: {$value}";
        }

        return implode(', ', $variants);
    }

    public function recalculateSubtotal(): void
    {
        $this->subtotal = $this->unit_price * $this->quantity;
        $this->save();
    }
}
