<?php

namespace App\Http\Controllers;

use App\Services\AsaasService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class WebhookController extends Controller
{
    protected $asaasService;

    public function __construct(AsaasService $asaasService)
    {
        $this->asaasService = $asaasService;
    }

    /**
     * Receber webhooks do Asaas
     */
    public function asaas(Request $request)
    {
        try {
            $event = $request->input('event');

            Log::info('Webhook Asaas recebido', ['event' => $event, 'data' => $request->all()]);

            // Processar diferentes tipos de eventos
            switch ($event) {
                case 'PAYMENT_CONFIRMED':
                case 'PAYMENT_RECEIVED':
                    $this->asaasService->updateOrderStatusFromWebhook($request->all());
                    break;

                case 'PAYMENT_OVERDUE':
                case 'PAYMENT_DELETED':
                    $this->asaasService->updateOrderStatusFromWebhook($request->all());
                    break;

                case 'PAYMENT_AWAITING_RISK_ANALYSIS':
                    // Pagamento em análise de risco
                    break;

                default:
                    Log::warning('Evento Asaas não tratado', ['event' => $event]);
            }

            return response()->json(['status' => 'ok']);
        } catch (\Exception $e) {
            Log::error('Erro ao processar webhook Asaas', ['error' => $e->getMessage()]);
            return response()->json(['status' => 'error'], 500);
        }
    }
}
