<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use App\Models\Testimonial;

class HomeController extends Controller
{
    public function index()
    {
        $featuredProducts = Product::active()
            ->featured()
            ->with(['category', 'images'])
            ->limit(8)
            ->get();

        $categories = Category::active()
            ->root()
            ->withCount('products')
            ->limit(6)
            ->get();

        $testimonials = Testimonial::active()
            ->limit(6)
            ->get();

        $discountProducts = Product::active()
            ->withDiscount()
            ->with(['category', 'images'])
            ->limit(4)
            ->get();

        return view('home', compact(
            'featuredProducts',
            'categories',
            'testimonials',
            'discountProducts'
        ));
    }
}
