<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = Category::active()
            ->root()
            ->with(['children', 'products' => function ($query) {
                $query->active()->limit(4);
            }])
            ->withCount('products')
            ->get();

        return view('categories.index', compact('categories'));
    }

    public function show($slug)
    {
        $category = Category::active()
            ->with('parent')
            ->where('slug', $slug)
            ->firstOrFail();

        $products = Product::active()
            ->where('category_id', $category->id)
            ->with(['images'])
            ->paginate(12);

        $childCategories = Category::active()
            ->where('parent_id', $category->id)
            ->withCount('products')
            ->get();

        return view('categories.show', compact('category', 'products', 'childCategories'));
    }
}
