<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Product;
use App\Models\Combo;
use App\Models\User;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        // Estatísticas gerais
        $stats = [
            'total_orders' => Order::count(),
            'pending_orders' => Order::where('status', Order::STATUS_PENDING)->count(),
            'total_products' => Product::count(),
            'total_combos' => Combo::count(),
            'total_users' => User::customers()->count(),
            'total_revenue' => Order::where('payment_status', Order::PAYMENT_PAID)->sum('total'),
        ];

        // Pedidos recentes
        $recentOrders = Order::latest()
            ->take(5)
            ->get();

        // Pedidos pendentes
        $pendingOrders = Order::where('status', Order::STATUS_PENDING)
            ->latest()
            ->take(10)
            ->get();

        // Vendas dos últimos 7 dias
        $salesLast7Days = Order::where('payment_status', Order::PAYMENT_PAID)
            ->where('created_at', '>=', now()->subDays(7))
            ->select(DB::raw('DATE(created_at) as date'), DB::raw('SUM(total) as total'))
            ->groupBy('date')
            ->orderBy('date')
            ->get();

        // Produtos mais vendidos
        $topProducts = DB::table('order_items')
            ->select('product_name', DB::raw('SUM(quantity) as total_sold'), DB::raw('SUM(subtotal) as revenue'))
            ->whereNotNull('product_id')
            ->groupBy('product_id', 'product_name')
            ->orderByDesc('total_sold')
            ->take(5)
            ->get();

        // Combos mais vendidos
        $topCombos = DB::table('order_items')
            ->select('product_name', DB::raw('SUM(quantity) as total_sold'), DB::raw('SUM(subtotal) as revenue'))
            ->whereNotNull('combo_id')
            ->groupBy('combo_id', 'product_name')
            ->orderByDesc('total_sold')
            ->take(5)
            ->get();

        // Status dos pedidos
        $ordersByStatus = Order::select('status', DB::raw('COUNT(*) as count'))
            ->groupBy('status')
            ->pluck('count', 'status')
            ->toArray();

        // Status de pagamento
        $ordersByPaymentStatus = Order::select('payment_status', DB::raw('COUNT(*) as count'))
            ->groupBy('payment_status')
            ->pluck('count', 'payment_status')
            ->toArray();

        return view('admin.dashboard', compact(
            'stats',
            'recentOrders',
            'pendingOrders',
            'salesLast7Days',
            'topProducts',
            'topCombos',
            'ordersByStatus',
            'ordersByPaymentStatus'
        ));
    }
}
