# Suplementos Store - Landing Page de Catálogo

Landing page profissional para catálogo de suplementos alimentares, desenvolvida com Laravel 11, MySQL e Tailwind CSS.

## Características

- Catálogo de produtos completo com filtros e busca
- Sistema de categorias e subcategorias
- Página de detalhes do produto com galeria de imagens
- Depoimentos de clientes
- Design responsivo (mobile-first)
- SEO otimizado com meta tags
- Badges de desconto e produtos em destaque

## Requisitos

- PHP 8.2+
- Composer 2+
- MySQL 8.0+ ou SQLite
- Servidor web (Apache, Nginx, ou PHP built-in server)

## Instalação Local

### 1. Navegue até o diretório do projeto

```bash
cd suplementos
```

### 2. Instale as dependências (se necessário)

```bash
composer install
```

### 3. Configure o ambiente

O arquivo `.env` já foi criado automaticamente. Se necessário, edite as configurações:

```bash
# .env
APP_NAME="Suplementos Store"
APP_ENV=local
APP_KEY=base64:...
APP_DEBUG=true
APP_URL=http://localhost:8000

DB_CONNECTION=sqlite
# Ou use MySQL:
# DB_CONNECTION=mysql
# DB_HOST=127.0.0.1
# DB_PORT=3306
# DB_DATABASE=suplementos
# DB_USERNAME=seu_usuario
# DB_PASSWORD=sua_senha
```

### 4. Execute as migrations e seeders

```bash
php artisan migrate:fresh --seed
```

Isso criará todas as tabelas e populará com:
- 6 categorias
- 10 produtos de exemplo
- 8 depoimentos

### 5. Inicie o servidor de desenvolvimento

```bash
php artisan serve
```

Acesse: `http://localhost:8000`

## Estrutura do Projeto

```
suplementos/
├── app/
│   ├── Http/
│   │   └── Controllers/
│   │       ├── HomeController.php
│   │       ├── ProductController.php
│   │       ├── CategoryController.php
│   │       └── TestimonialController.php
│   └── Models/
│       ├── Category.php
│       ├── Product.php
│       ├── ProductImage.php
│       ├── ProductFeature.php
│       └── Testimonial.php
├── database/
│   ├── migrations/
│   └── seeders/
├── resources/
│   └── views/
│       ├── layouts/
│       │   └── app.blade.php
│       ├── partials/
│       │   ├── header.blade.php
│       │   ├── footer.blade.php
│       │   ├── newsletter.blade.php
│       │   └── product-card.blade.php
│       ├── home.blade.php
│       ├── products/
│       │   ├── index.blade.php
│       │   └── show.blade.php
│       ├── categories/
│       │   ├── index.blade.php
│       │   └── show.blade.php
│       └── testimonials/
│           └── index.blade.php
└── routes/
    └── web.php
```

## Rotas Disponíveis

| Rota | Descrição |
|------|-----------|
| `/` | Página inicial (Landing Page) |
| `/produtos` | Catálogo de produtos com filtros |
| `/produtos/{slug}` | Detalhes do produto |
| `/categorias` | Lista de categorias |
| `/categorias/{slug}` | Produtos por categoria |
| `/depoimentos` | Página de depoimentos |

## Hospedagem na Paraela Hospedagem

### 1. Upload dos arquivos

Faça upload de todos os arquivos do projeto (exceto `node_modules` e `vendor`) via FTP ou SFTP.

### 2. Configure o banco de dados

1. Crie um banco de dados MySQL no painel da Paraela
2. Importe as migrations via SSH ou use o phpMyAdmin

```bash
php artisan migrate --force
php artisan db:seed --force
```

### 3. Configure o .env

Edite o arquivo `.env` no servidor:

```env
APP_ENV=production
APP_DEBUG=false
APP_URL=https://seu-dominio.com.br

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=nome_do_banco
DB_USERNAME=usuario_mysql
DB_PASSWORD=senha_mysql
```

### 4. Configure as permissões

```bash
chmod -R 755 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache
```

### 5. Otimização para produção

```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## Personalização

### Cores

As cores principais são configuradas via Tailwind CSS no arquivo `resources/views/layouts/app.blade.php`:

```javascript
colors: {
    primary: {
        // Azul (#1e40af)
    },
    secondary: {
        // Laranja (#f97316)
    }
}
```

### Imagens dos Produtos

As imagens atuais são placeholders do serviço placehold.co. Substitua os URLs no `ProductSeeder` ou faça upload das imagens reais.

### Logo

Substitua o logo no arquivo `resources/views/partials/header.blade.php` e `footer.blade.php`.

## Dados de Exemplo

O projeto vem com 10 produtos de exemplo nas seguintes categorias:
- Proteínas (Whey Protein Concentrado, Whey Isolado, Caseína)
- Creatina (Creatina Monohidratada)
- Aminoácidos (BCAA 2:1:1)
- Termogênicos (Pro Burn)
- Vitaminas e Minerais (Multivitamínico, ZMA, Ômega 3)
- Pré-Treino (Ignite)

## Funcionalidades Futuras

- Carrinho de compras real
- Sistema de autenticação
- Área administrativa
- Integração com gateways de pagamento
- Sistema de avaliações de produtos
- Newsletter com envio real de emails

---

Desenvolvido com Laravel 11 + Tailwind CSS
